/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Translator {
    static final String INIT_STATE = "InitialNode1";
    static final String GENERATE_FAIL_STATE = "uml:OpaqueAction";
    static final String FAIL_STATE = "FAIL_STATE";
    static final String FAIL = "Fail";
    private Document doc;

    public Translator(String fileName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(new File(fileName));
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private Edge constructEdge(Node aNode) {
        Edge e = new Edge();
        NamedNodeMap ats = aNode.getAttributes();
        e.type = ats.getNamedItem("xmi:type").getNodeValue();
        e.id = ats.getNamedItem("xmi:id").getNodeValue();
        e.name = ats.getNamedItem("name").getNodeValue();
        e.source = ats.getNamedItem("source").getNodeValue();
        e.target = ats.getNamedItem("target").getNodeValue();
        e.pTransition = "1.0";
        if (e.name != null && e.name.contains("(")) {
            String probability;
            int lbracket = e.name.indexOf("(");
            int rbracket = e.name.indexOf(")");
            e.pTransition = probability = e.name.substring(lbracket + 1, rbracket);
        }
        return e;
    }

    private State constructState(Node aNode, int n) {
        State s = new State();
        NamedNodeMap ats = aNode.getAttributes();
        s.n = n;
        s.type = ats.getNamedItem("xmi:type").getNodeValue();
        s.id = ats.getNamedItem("xmi:id").getNodeValue();
        s.name = ats.getNamedItem("name").getNodeValue();
        s.outgoingEdges = ats.getNamedItem("outgoing") == null ? "" : ats.getNamedItem("outgoing").getNodeValue();
        s.incomingEdges = ats.getNamedItem("incoming") == null ? "" : ats.getNamedItem("incoming").getNodeValue();
        return s;
    }

    public static String pctl(String requirement, String node) {
        String pctl = "";
        String[] a = requirement.split(";");
        if (!a[1].equals("true")) {
            pctl = String.valueOf(pctl) + "filter(forall,";
        }
        pctl = String.valueOf(pctl) + a[0] + "[";
        pctl = node != null ? String.valueOf(pctl) + "!(" + node + ")U" : String.valueOf(pctl) + "F";
        pctl = String.valueOf(pctl) + "(" + a[2] + ")]";
        if (!a[1].equals("true")) {
            pctl = String.valueOf(pctl) + "," + a[1] + ")";
        }
        return pctl;
    }

    public PrismModel processXML() {
        PrismModel pm = new PrismModel();
        State failState = null;
        String finalStateID = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList comments = this.doc.getElementsByTagName("ownedComment");
        int i = 0;
        while (i < comments.getLength()) {
            if (comments.item(i).getTextContent().contains(FAIL_STATE)) {
                finalStateID = comments.item(i).getAttributes().getNamedItem("annotatedElement").getNodeValue();
            } else {
                properties.put(comments.item(i).getTextContent().trim(), comments.item(i).getAttributes().getNamedItem("annotatedElement").getNodeValue());
            }
            ++i;
        }
        NodeList edges = this.doc.getElementsByTagName("edge");
        int i2 = 0;
        while (i2 < edges.getLength()) {
            pm.addEdge(this.constructEdge(edges.item(i2)));
            ++i2;
        }
        NodeList states = this.doc.getElementsByTagName("node");
        int i3 = 0;
        while (i3 < states.getLength()) {
            State an = this.constructState(states.item(i3), i3);
            pm.addState(an);
            if (an.id.contentEquals(finalStateID)) {
                failState = an;
            }
            ++i3;
        }
        ArrayList<State> failStates = new ArrayList<State>();
        int nFail = pm.getStates().size();
        for (State an : pm.getStates()) {
            if (!an.type.contentEquals(GENERATE_FAIL_STATE)) continue;
            String[] stringArray = an.outgoingEdges();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Edge e = pm.getEdge(id);
                e.pTransition = String.valueOf(an.name) + "_p";
                ++n2;
            }
            State s1 = new State();
            s1.id = String.valueOf(an.id) + FAIL;
            s1.name = String.valueOf(an.name) + FAIL;
            s1.type = String.valueOf(an.type) + FAIL;
            s1.n = nFail++;
            failStates.add(s1);
            Edge e2 = new Edge();
            e2.id = String.valueOf(s1.id) + "Edge2";
            e2.source = an.id;
            e2.target = s1.id;
            e2.pTransition = "(1-" + an.name + "_p)";
            pm.addEdge(e2);
            s1.incomingEdges = String.valueOf(s1.incomingEdges) + " " + e2.id;
            an.outgoingEdges = String.valueOf(an.outgoingEdges) + " " + e2.id;
            Edge e3 = new Edge();
            e3.id = String.valueOf(s1.id) + "Edge3";
            e3.source = s1.id;
            e3.target = failState.id;
            e3.pTransition = "1.0";
            pm.addEdge(e3);
            s1.outgoingEdges = e3.id;
            failState.incomingEdges = String.valueOf(failState.incomingEdges) + " " + e3.id;
        }
        for (State s : failStates) {
            pm.addState(s);
        }
        for (String p : properties.keySet()) {
            String nodeId = (String)properties.get(p);
            State state = pm.states.get(nodeId);
            pm.addpctlFormulae(Translator.pctl(p, state.name.contains("ActivityFinalNode") ? null : String.valueOf('\"') + state.name + '\"'));
        }
        return pm;
    }
}

