package ipSupportTool;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.Result;

public class AutonomicManager {
	static Logger logger = Logger.getLogger("");
	static private final String costFormula = "R=?[F a=10]";

	private Model paramDTMCModel;
	private int nabstract;

	private ArrayList<ConcreteServiceConfiguration> concreteConfigs;

	private IPSupport[] ipsupport;
	private String[] observableMethod;

	private PrismLog mainLog;
	private Prism prism;
	private ModulesFile modulesFile;
	private PropertiesFile propertiesFile;


	//------------------------------------------------------------------------------------------------------------------------
	//calculate the number of possible concrete service combinations: nconcrete[0] * ... * nconcrete[nabstract-1]
	public int maxConfigSpaceSize(){		
		int num_configs = 1;
		for(int a=0;a<this.nabstract;a++) 			
			num_configs*= this.ipsupport[a].nconcrete();//determine how many configurations there are

		return num_configs;		
	}
	//------------------------------------------------------------------------------------------------------------------------
	//initialises "verifiedServiceConfigurations" with all possible combinations of concrete services.
	private void initialiseVerificationConfigSpace(){


		this.concreteConfigs = new ArrayList<ConcreteServiceConfiguration>();
		

		int num_configs = this.maxConfigSpaceSize();

		int[][] completeConfigSpace = new int[num_configs][];
		for(int i=0;i< num_configs;i++)
			completeConfigSpace[i] = new int[nabstract];

		//populate verifiedServiceConfigurations arraylist with configs.
		int m= num_configs;
		for(int a = 0; a< this.nabstract;a++){
			int counter=0;	 			 
			int d = (m/this.ipsupport[a].nconcrete());
			for(int i=0;i<num_configs;i++){	
				d--;
				completeConfigSpace[i][a] = counter;
				if(d==0) {counter++;d = (m/this.ipsupport[a].nconcrete());}
				if(counter > this.ipsupport[a].nconcrete()-1) counter=0;
			}
			m = m/this.ipsupport[a].nconcrete();		     
		}

		for(int i=0;i<num_configs;i++)
			this.concreteConfigs.add(new ConcreteServiceConfiguration(this.nabstract,completeConfigSpace[i]));				
	}
	//------------------------------------------------------------------------------------------------------------------------
	/*constructor for the AutonomicManager.*/
	public AutonomicManager(Model aModel,int nabstract,IPSupport[] ipsupport,String[] observableMethod) 
			throws PrismException{  

		logger.info("Autonomic Mangaer Invoked with the following services:");		
		for(int i=0;i<nabstract;i++) logger.info(ipsupport[i]);

		this.paramDTMCModel = aModel;
		this.nabstract = nabstract;		  

		this.ipsupport = ipsupport;
		this.observableMethod = observableMethod;

		mainLog = new PrismFileLog("/dev/null");
		prism = new Prism(mainLog, mainLog);

		try {
			prism.initialise();
		} catch (PrismException e) {
			logger.info(" PRISM EXCEPTION : " + e.getMessage());//log this error and report to user.
		}

		//where should prism be closed down?
		//prism.closeDown(false);

		//initially, the verification space contains all concrete service configurations. 
		this.initialiseVerificationConfigSpace();
	}
	//------------------------------------------------------------------------------------------------------------------------
	//
	private String setProxyDataParms(String model,ConcreteServiceConfiguration config ){
		for(int a=0;a<this.nabstract;a++){
			String methodName = this.ipsupport[a].getMethodNames();
	
			model = model.replace("%"+methodName+"_p",(ipsupport[a].getpSucc(methodName)[config.getConfig()[a]])+"");
			model = model.replace("%"+methodName+"_COST",(ipsupport[a].getCost(methodName)[config.getConfig()[a]])+"");

		}
		model= "//CONCRETE SERVICE REPRESENTATION:  "+config+" "+model;
		logger.info("[AM: CONCRETE_CONFIG]" + config);
		logger.info("[PRISM: Model]" + model); 
		return model;
	}
	//------------------------------------------------------------------------------------------------------------------------
	private Result executePrism(String model,String property){
		Result result = null;
		try {
			modulesFile = prism.parseModelString(model);
			propertiesFile = prism.parsePropertiesString(modulesFile,property);

			prism.buildModel(modulesFile);
			result = prism.modelCheck(propertiesFile, propertiesFile.getPropertyObject(0));	
		}
		catch (PrismException e) {
			logger.info("Prism Error: " + e.getMessage());
		}
		return result;
	}
	//------------------------------------------------------------------------------------------------------------------------
	private void determineRequirementsSatisfiability(String[ ]pctlProperty) throws Exception{

		ArrayList<ConcreteServiceConfiguration> nonSAT = new ArrayList<ConcreteServiceConfiguration>();
		for(ConcreteServiceConfiguration config : this.concreteConfigs){
			String model = this.setProxyDataParms(paramDTMCModel.getModel(), config);

			//now determine if the config satisfies the PCTL properties representing the QoS requirements
			boolean isSAT=true;
			for(int pctlIndex=0;pctlIndex<pctlProperty.length;pctlIndex++){				
				logger.info("[PRISM:PCTL]  "+pctlProperty[pctlIndex]);				
				if(isSAT){
					Result result=this.executePrism(model,pctlProperty[pctlIndex]);
					isSAT= (Boolean)result.getResult() && isSAT;//if not satisfied, don't bother verifying the other pctls 				
				}
			}
			if(!isSAT)//this config should be removed since it does not satisfy the requirements.
				nonSAT.add(config);			
		}

		this.concreteConfigs.removeAll(nonSAT);//removal all the configs that do not satisfy the properties.

		if (this.concreteConfigs.size() == 0) throw new Exception("No concrete services satisfy the requirements. "  + "  timestamp  " + System.currentTimeMillis() / 1000 );

		//Now find the cost of all service configurations satisfying the requirements. 
		for(ConcreteServiceConfiguration config : this.concreteConfigs){
			String model = this.setProxyDataParms(paramDTMCModel.getModel(),config);			
			Result cost=this.executePrism(model,costFormula);
			if (null==cost) throw new Exception("Error with rewards model.");
			config.setCost((Double)cost.getResult());	
		}

	}

	//------------------------------------------------------------------------------------------------------------------------
	/*Given a set of pctl formula expressing requirements, find the configuration of concrete sercvices that satisfies the requirements 
	 *and is the most cost effective.
	 */
	public void selectConcreteServices(String[] pctlProperties) throws Exception {
		if (pctlProperties.length == 0) throw new Exception("No properties specified.");

		//reinitialise the verification space to contain all the possible configurations of concrete services.
		this.initialiseVerificationConfigSpace();

		//populates "verifiedServiceConfigurations" with only those service configurations that satisfy the requirements in the list "pctlProperties". 
		this.determineRequirementsSatisfiability(pctlProperties);		

		logger.info("QoS:SatisfiedByHowManyCombinationsOfConcreteServices]  "+this.concreteConfigs.size());

		//from the arraylist "this.verifiedServiceConfigurations" find the index of the most cost effective configuration of conrete services.
		double minCost=Double.MAX_VALUE;
		ConcreteServiceConfiguration minCostConfig = this.concreteConfigs.get(0);

		for(ConcreteServiceConfiguration config : this.concreteConfigs)
			if (config.getCost()<minCost){
				minCost=config.getCost();
				minCostConfig=config;
			}

		String selectedCombination = "";
		for (int a = 0; a < this.nabstract; a++) {

			//IPSUPPORT IS MODIFIED.
			this.ipsupport[a].setMethodIndex(this.observableMethod[a], minCostConfig.getConfig()[a]);
			selectedCombination += this.observableMethod[a] + ":" + minCostConfig.getConfig()[a] + ", ";
		}
		//System.out.println(this.concreteConfigs.size());
		logger.info("[AM:SelectedConcreteServiceCombination]  " + selectedCombination + " at a cost of " + minCost + "  timestamp  " + System.currentTimeMillis() / 1000);
	
	}	  
	//------------------------------------------------------------------------------------------------------------------------
}
