/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Yasmin Rafiq, 
 *  {radu.calinescu, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package ipSupportTool;

import org.apache.log4j.Logger;

public class Method {
	private double cost; 
	private TransitionProbability successRate;
	private static Logger logger = Logger.getLogger("");


	// Constructor
	public Method(double cost, double aprioriSuccRate) {
		// 1. Record method cost
		this.cost = cost;

		// 2. Instantiate transition probability object to maintain estimate success rate
		successRate = new TransitionProbability(aprioriSuccRate);

	}

	// Method for checking SLA compliance
	public boolean satisfiesSLA(MethodSLA sla) {
		// 1. Get current success rate estimate
		double estimateSuccRate = successRate.getEstimate();

		// 2. Check SLA compliance
		if(cost <= sla.getMaxCost() && estimateSuccRate >= sla.getMinSuccRate()) {
			logger.info("Service SLA Cost = " + sla.getMaxCost() + "| Service Cost = " + cost );
			logger.info("Service SLA minSuccRate = " + sla.getMinSuccRate() + " | Service MinSuccRate = " + estimateSuccRate);

			return true; 
		}

		// 3. Add log entry if SLA not satisfied
		else{
			System.out.println("Service SLA not satisfied");
			logger.info("Service SLA not satisfied");
			return false; 
		}
	}

	// Record a successful web method invocation
	public void recordSuccess(){
		successRate.successfulInvocation();
	}

	// Record failed web method invocation
	public void recordFailure(){
		successRate.unsuccessfulInvocation();
	}

	// Record discontinuation of web method usage
	public void recordStoppedUsing(){
		successRate.stoppedMonitoring();
	}

	//
	public void setMethodCost(double sCost){
		this.cost = sCost;
	}

	public void setPriorValue(double pPrior){
		successRate.setPriorValue(pPrior);
	}

	public void setSmoothingParameter(double c0){
		successRate.setSmoothingPrameter(c0);
	}

	public void setAlpha(double alpha){
		successRate.setAlpha(alpha);
	}

	//
	public double getServiceCost(){
		System.out.println("Service cost = " + cost);
		return cost;
	}

	// return current estimate
	public double getEstimate() {
		return successRate.getEstimate();
	}

	// return current estimate timestamp
	public long get_tk(){
		return successRate.get_tk();
	}

	// return cost of method
	public double getCost(){
		return cost; 
	}

}
