/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Yasmin Rafiq, 
 *  {radu.calinescu, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package ipSupportTool;

public class MethodSLA {
	// SLAs for Service Method 
	private double minSuccRate;
	private double maxCost;

	// Assign SLA for Method
	public MethodSLA(double minSuccRate, double maxCost){
		this.minSuccRate = minSuccRate; 
		this.maxCost = maxCost; 
	}

	// Retrieve Minimum Success Rate for invoking the Service Method  
	public double getMinSuccRate (){
		return this.minSuccRate;
	}

	// Update Minimum Success Rate for Service Method 
	public void setMinSuccRate(double minSuccRate){
		this.minSuccRate = minSuccRate; 
	}

	// Retrieve Maximum Cost for invoking the Service Method
	public double getMaxCost(){
		return this.maxCost;
	}

	// Update Maximum Cost for Service Method 
	public void setMaxCost(double mxCost){
		this.maxCost = mxCost; 
	}
}
