package ipSupportTool;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;

public class Model {
	private int X_TOKEN = 3;
	private int Y_TOKEN = 4;
	private int Z_TOKEN = 5;
	private HashMap<String,HashMap<String,TransitionProbability>> learnedTransitions;
	static private String P_PARSE_STRING = "const double p_";
	private String model = "request";


	static private String RESTART_STRING = "request";
	private static Logger logger = Logger.getLogger("");

	private String previousOperation = "";

	private String _grepping = "[Model_CLASS]";//log2j
	//------------------------------------------------------------------------------------------
	public void restartWorkFlow(){
		this.previousOperation = RESTART_STRING;
	}
	//------------------------------------------------------------------------------------------
	public void nextInvocation(String operationName){


		logger.info(_grepping+" [nextInvocation] "+this.previousOperation+" "+operationName);
		HashMap<String,TransitionProbability> Ys = this.learnedTransitions.get(previousOperation);//e.g. X


		if ( Ys != null){		
			TransitionProbability Z =  Ys.get(operationName);

			if (Z!= null) 
				Z.successfulInvocation();//sigma = 1

			logger.info(_grepping+" [Learnedtransition] "+previousOperation+" -> "+operationName+" = "+Ys.get(operationName));

			
			
			for(String opName : Ys.keySet())
				if (!opName.contentEquals(operationName)){
					TransitionProbability Zprime = Ys.get(opName);
					if(Zprime!=null) Zprime.unsuccessfulInvocation();
				}


		} else 


			logger.error(_grepping+" I couldn't find operation "+previousOperation);


		this.previousOperation = operationName;

	}
	//------------------------------------------------------------------------------------------
	private boolean isTransitionLine(String line){
		return line.contains(P_PARSE_STRING);
	}
	//------------------------------------------------------------------------------------------
	private ArrayList<String> tokenizeTransitionLine(String line){
		ArrayList<String> tokens = new ArrayList<String>();

		StringTokenizer trans = new StringTokenizer(line,"_=; ");		
		while(trans.hasMoreTokens())					
			tokens.add(trans.nextToken());

		return tokens;
	}
	//------------------------------------------------------------------------------------------
	//Given a single line from a DTMC prism model of the form "const double p_X_Y = Z;"
	//constructs and adds an entry to the learnedTransitions map with the form X_Y -> Z,  
	private void addTransitionProbabilities(String line){
		ArrayList<String> tokens = tokenizeTransitionLine(line);
		if(tokens.size()>=3){

			//first, get the transition data of the form X_Y -> Z 
			Double val = new Double(tokens.get(Z_TOKEN));
			TransitionProbability Z = new TransitionProbability(val);
			String X = tokens.get(X_TOKEN);
			String Y = tokens.get(Y_TOKEN);

			//does X already have a hashmap associated with it containing other transitions?
			HashMap<String,TransitionProbability>
			pTrans = this.learnedTransitions.get(X);

			if (null == pTrans){//no, there is no hashamp assocated weith X, create new one
				pTrans = new 
				HashMap<String,TransitionProbability>();
				this.learnedTransitions.put(X,pTrans);//npw, associate X with this new hashmap.
			}

			if (pTrans.get(Y) != null) //change this to log2j
				logger.info(_grepping+" Warning: I am replacing value: "+pTrans.get(Y)+
						" with "+Z+" for transition: "+X+" -> "+Y);

			pTrans.put(Y,Z);//associate Y with the transition probability value

		}			
	}
	//----------------------------------------------------------------------------------------
	private double normaliseTransition(String X,String Y){
		HashMap<String,TransitionProbability> Ys = learnedTransitions.get(X);

		double estimateSum=0.0;
		for(TransitionProbability Z : Ys.values())
			estimateSum += Z.getEstimate();

		//return the normalised value, avoiding a divide by zero error
		return (estimateSum!=0)?(learnedTransitions.get(X).get(Y).getEstimate()/estimateSum):
			(learnedTransitions.get(X).get(Y).getEstimate());

	}
	//----------------------------------------------------------------------------------------
	public Model(String modelFilePath){
		//initialise the hashmap of transitions to learn
		this.learnedTransitions = new HashMap<String,HashMap<String,TransitionProbability>>();

		//read model file and populate learnedTransitions map.
		this.model = this.readFile(modelFilePath); 
	}
	//----------------------------------------------------------------------------------------
	//update the model string with the latest transition probability values from 
	//the learnedProbabiloity hashmap and return the model.

	public String getModel(){
		String newModel = "";
		StringTokenizer tokens = new StringTokenizer(model,"\n");
		while(tokens.hasMoreTokens()){
			String line = tokens.nextToken();
			if(this.isTransitionLine(line)){
				ArrayList<String> a = tokenizeTransitionLine(line);

				if(a.size()>=3){//make sure that the array is at least the correct size.
					//now construct a new pTransition line from data stored in learnedTransitions map.
					//using the X_Y -> Z form of the key/value pairs stored in the map
					String X = a.get(X_TOKEN); //System.out.println("X : " + X);
					String Y = a.get(Y_TOKEN); //System.out.println("Y : " + Y);

					//return a normalised value such that the sum of transition probabilities = 1 
					String Z = normaliseTransition(X,Y)+""; //System.out.println("Z : " + Z);
					String newLine = 	"\n"+P_PARSE_STRING+X+"_"+Y+" = "+Z+";\n";				
					newModel+=newLine;
				} else logger.error(_grepping+" Error: I had problems parsing a transitions probability line");

			}else newModel+="\n"+line+"\n";
		}

		//now update the instance variable "model" with values from the learnedProbabilityTransition
		this.model = newModel;




		return model; 
	}
	//----------------------------------------------------------------------------------------
	//Read the model file to store in a string, while populating the learnedTransitions map. 
	private String readFile(String filename){
		Scanner sc;
		String aux="";
		try {sc = new Scanner(new File(filename));
		while (sc.hasNext()) {
			String line = sc.nextLine()+"\n";
			if(isTransitionLine(line))				
				addTransitionProbabilities(line);			
			aux=aux+line;
		}
		sc.close();

		}catch (FileNotFoundException e) {			
			e.printStackTrace();
		} 		
		return aux;
	}
	//----------------------------------------------------------------------------------------	
}
