/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Yasmin Rafiq, 
 *  {radu.calinescu, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package ipSupportTool;

import java.util.HashMap;
import java.util.Map.Entry;


public class Service {
	// Keep a dictionary mapping web method names (as known to the client) to method objects
	private HashMap<String,Method> methods; 

	// 
	public Service(String[] methodNames, double[] costs, double[] aprioriSuccRates) throws Exception{
		// 1. Create hash map
		methods = new HashMap<String,Method>();

		// 2. Populate HashMap
		for (int i = 0; i < methodNames.length; i++) {
			methods.put(methodNames[i], new Method(costs[i], aprioriSuccRates[i]));
		}

	}

	//
	public boolean satisfiesSLA(String methodName, MethodSLA sla){
		// 1. Check that this service has the required web method
		if (!methods.containsKey(methodName)) {
			return false;
		}

		// 2. Check SLA compliance
		return methods.get(methodName).satisfiesSLA(sla); 
	}

	//
	public void recordSuccess(String methodName) {
		// 1. Pass on the success recording to the actual method involved
		methods.get(methodName).recordSuccess();
	}

	//
	public void recordFailure(String methodName) {
		// 1. Pass on the failure recording to the actual method involved
		methods.get(methodName).recordFailure();
	}

	//
	public void recordStoppedUsing(String methodName) {
		// 1. Pass on the failure recording to the actual method involved
		methods.get(methodName).recordStoppedUsing();
	}

	// return current estimate
	public double getEstimate(String methodName) {
		return methods.get(methodName).getEstimate();
	}

	// return current estimate timestamp
	public long get_tk(String methodName){
		return methods.get(methodName).get_tk();
	}

	// return cost of method
	public double getCost(String methodName){
		return methods.get(methodName).getCost();
	}

	//New* by Yasmin March 04/2013
	public String getMethodName(){
		Entry<String, Method> entry = methods.entrySet().iterator().next();
		String delims = "[=]+";
		String[] tokens =  entry.toString().split(delims);  
		return tokens[0];
	}

	public boolean hasMethod(String methodName){
		// 1. Check that this service has the required web method
		if (!methods.containsKey(methodName)) {
			return false; 
		}
		else{
			return true;
		}
	}

	public void setMethodCost(String methodName, double cost){
		methods.get(methodName).setMethodCost(cost);	
	}

	public void setMethodPriorValue(String methodName, double pPrior){
		methods.get(methodName).setPriorValue(pPrior);
	}

	public void setMethodAlphaValue(String methodName, double alpha){
		methods.get(methodName).setAlpha(alpha);
	}

	public void setMethodSmoothingParameter(String methodName, double c0){
		methods.get(methodName).setSmoothingParameter(c0);
	}
}
