/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package buildIntelligentProxy;

import java.io.*;
import java.util.*;

public class BuildProxy {

	static private String proxyName;
	static private String packageName; 
	static private ArrayList<String> proxyMethodSignatures;
	static private ArrayList<String> URLs;
	static private ArrayList<ArrayList<String>> serviceMethodNames;
	static private String outputDir;
	static private ArrayList<String> pathName;
	static private String JAVA_HOME; 
	static private String AXIS2_HOME;  
	static private String w2jCommand; 
	static private ArrayList<Integer> serviceMethodParameters;
	static private ArrayList<String> serviceMethodReturnType;


	/**
	 * @param args
	 */
	//method used to delete existing build.xmkl file 
	private static void deletefile(String file){
		File f1 = new File(file);
		boolean success = f1.delete();
		if (!success){
			System.out.println("Deletion failed. " + file);
		}else{
			System.out.println("File deleted. " + file);
		}
	}

	//
	// The command takes as parameter the path to a configuration file with the structure below:
	// 
	// intelligent-proxy-name
	// method-signature-1
	// ...
	// method-signature-n
	//
	//  web-service-wsdl-url-1
	//  web-method-name-1-1
	//  web-method-name-1-2
	//  ...
	//  web-method-name-1-n
	//
	//  web-service-wsdl-url-2
	//  web-method-signature-2-1
	//  web-method-signature-2-2
	//  ...
	//  web-method-signature-2-n
	//
	//  ...
	//
	//  web-service-wsdl-url-m
	//  web-method-signature-m-1
	//  web-method-signature-m-2
	//  ...
	//  web-method-signature-m-n
	//

	//method used to read the configeration file for setting the environment variables
	private static void parseConfigEnv(String envCfgFilePath){
		//Intialise field
		JAVA_HOME = ""; 

		try{
			// Open the file that is the first command-line parameter to set System Enviroment
			FileInputStream fstream = new FileInputStream(envCfgFilePath);

			// Get the object of DataInputStream
			DataInputStream in = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(in));

			// Read System Environment details
			String strLine;
			if ((strLine = br.readLine()) != null) {
				JAVA_HOME = strLine;
			}
			System.out.println(JAVA_HOME);

			if((strLine = br.readLine()) != null){
				AXIS2_HOME =  "AXIS2_HOME=" + System.getProperty("user.dir") + strLine;
				System.out.println(AXIS2_HOME);
			}

			if ((strLine = br.readLine()) != null) {
				w2jCommand = strLine;
			}
			System.out.println(w2jCommand);

		} catch (Exception e){
			System.err.println("Error: " + e.getMessage());
		}
	}

	//method used to read the configuration file generated by GUI for each wsdl document
	private static void parseConfig(String cfgFilePath) {
		// Initialise fields
		proxyName = "";
		packageName = "";
		proxyMethodSignatures = new ArrayList<String>();

		URLs = new ArrayList<String>();
		serviceMethodNames = new ArrayList<ArrayList<String>>();


		try{
			// Open the file that is the first command-line parameter
			FileInputStream fstream = new FileInputStream(cfgFilePath);

			// Get the object of DataInputStream
			DataInputStream in = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(in));

			// Read intelligent proxy details
			String strLine;
			if ((strLine = br.readLine()) != null) {
				proxyName = strLine;
			}
			if ((strLine = br.readLine()) != null) {
				packageName = strLine;
				while ((strLine = br.readLine()) != null && !strLine.equals("")) {

					proxyMethodSignatures.add(strLine);

				}
			}

			serviceMethodParameters = new ArrayList<Integer>();
			serviceMethodReturnType = new ArrayList<String>();

			for(int i=0; i<proxyMethodSignatures.size(); i++){
				System.out.println(proxyMethodSignatures.get(i));
				String [] str = getArgList(proxyMethodSignatures.get(i));
				int numParameters = (str.length -2)/2; 
				System.out.println("numParameters = " + numParameters);
				serviceMethodParameters.add(numParameters);
				serviceMethodReturnType.add(str[0]);

			}

			for(int i=0; i<proxyMethodSignatures.size(); i++){
				System.out.println(proxyMethodSignatures.get(i));
			}

			// Read service details
			do {
				// Read details of one service
				String serviceWsdlUrl = br.readLine();

				ArrayList<String> webServiceMethodSignatures = new ArrayList<String>();
				while ((strLine = br.readLine()) != null && !strLine.equals("")) {
					webServiceMethodSignatures.add(strLine);
				}

				serviceMethodNames.add(webServiceMethodSignatures);
				URLs.add(serviceWsdlUrl);
			} while (strLine != null);

			// Close configuration file
			in.close();

			// Should really check that the same number of methods are listed for each web service, etc.
			// ...

			for (int i=0; i < serviceMethodNames.size(); i++){

				for(int j=0; j<serviceMethodNames.get(i).size(); j++){

					System.out.println(URLs.get(i) + " " + serviceMethodNames.get(i).get(j));
				}
			}

		} catch (Exception e){
			System.err.println("Error: " + e.getMessage());
		}	
	}

	//extract the concreate service names from wsdl URLs 
	static private String stubNameFromWsdlUrl(String wsdlUrl) {
		int start = wsdlUrl.lastIndexOf("/") + 1;
		int end = wsdlUrl.lastIndexOf("?");
		String result = wsdlUrl.substring(start, end);
		return result;
	}

	//return method names for each concreate service 
	static private String [] getArgList(String methodSignature) {

		String str = methodSignature;
		String delims = "[(,) ]+";
		String[] tokens = str.split(delims);
		return tokens; 
	}

	// generate the code for intelligent proxy .java file 
	static private void generateIntelligentProxy() throws Exception, IOException{
		// Output file for Java code
		BufferedWriter out = null;

		// Add prefix to proxyName
		String proxyFile = outputDir + "/" + proxyName + ".java";

		// 1. Delete file if it already exists
		deletefile(proxyFile);

		// 2. Generate intelligent proxy code
		try{
			// Open file in write mode
			FileWriter fstream = new FileWriter(proxyFile, true);			
			out = new BufferedWriter(fstream);
		} catch (Exception e){
			System.err.println("Error: " + e.getMessage());
		}	

		// 3. Write file header
		out.write("package " + packageName + ";");		
		out.newLine();
		out.newLine();
		out.write("import org.apache.axis2.addressing.EndpointReference;");
		out.newLine();
		out.write("import org.apache.log4j.*;");
		out.newLine();
		out.write("import java.util.*;");
		out.newLine();
		out.write("import ipSupportTool.*;");
		out.newLine();
		out.newLine();
		out.write("// The namespaces for the concrete services (NB: these are application specific!)");
		out.newLine();
		String nam = outputDir + "/build/classes";
		File aFile = new File(nam);
		pathName = Process2(aFile);

		for (int i = 0; i < pathName.size(); i++) {
			out.write("import " + pathName.get(i).substring(8) + ".*;");
			out.newLine();
		}

		out.newLine();
		out.newLine();
		out.write("// The Intelligent Proxy class");
		out.newLine();

		// 4. Write Java class header
		out.write("public class " + proxyName  + " extends IPSupport{");
		out.newLine();
		out.newLine();
		out.write("   // The actual stubs (NB: these are application specific!)");
		out.newLine();


		// 5. Generate class fields
		// 5.1. Generate one stub field for each web service
		for (int i=1; i <= URLs.size(); i++) {
			out.write("   private ");
			out.write(stubNameFromWsdlUrl(URLs.get(i-1)));
			out.write("Stub stub" + i +";");
			out.newLine();				
		}

		// 5.3 Setup log4j for logging 
		out.newLine();
		out.write("   // Setup the log4j logger ");
		out.newLine();
		out.write("   static Logger logger = Logger.getLogger(" + '"' + '"' + ");");
		out.newLine();
		out.newLine(); 
		// 5.3.2 Create a Model updater 
		out.write("   // Create a Model updater");
		out.newLine(); 
		out.write("   private Model model; ");
		out.newLine();
		out.newLine(); 
		
		// 6. Synthesise constructor
		out.newLine();
		out.write("   // Constructor (NB: these are application specific!)");
		out.newLine();
		out.write("   public " + proxyName +"(String methodName, String prefix, Model model) throws Exception {");
		out.newLine();
		out.newLine();
		out.write("    	 super(methodName, prefix);");
		out.newLine();
		out.newLine(); 
		out.write("         //1. Initialise the Model updater with the initial model provided");
		out.newLine(); 
		out.write("          this.model = model; ");
		out.newLine();
		out.newLine();
		out.write("       // 2. Initialise stubs for each concrete service");
		out.newLine();

		for (int i=1; i <= URLs.size(); i++) {
			out.write("       // 2." + i + " Initialise stub for web service number " + i);
			out.newLine();
			out.write("       stub" + i);
			out.write(" = new "); 
			out.write(stubNameFromWsdlUrl(URLs.get(i-1)) + "Stub();");
			out.newLine();
			out.write("       EndpointReference targetEpr" + i + " = new EndpointReference(" +'"'+ URLs.get(i-1) + '"' +");");
			out.newLine();
			out.write("       stub" +i+"._getServiceClient().setTargetEPR(targetEpr"+i+");");
			out.newLine();
			out.newLine();
		}

		out.write("       // 3. Create the service array");
		out.newLine();
		out.write("       // 3.1. Instantiate array");
		out.newLine();
		out.write("       services = new Service[" + URLs.size() + "];");
		out.newLine();
		out.write("       // 3.2. Declare arrays of abstract web method names, costs and a priory success rates");
		out.newLine();
		out.write("       String[] methodNames;");
		out.newLine();
		out.write("       double[] costs;");
		out.newLine();
		out.write("       double[] aPrioriSuccessRates;");
		out.newLine();
		out.newLine();
		out.write("       // 3.3. Instantiate services");
		out.newLine();

		// Visit each concrete service
		for (int i=0; i < serviceMethodNames.size(); i++){
			String a = "", b = "", c ="";

			// Visit each method of the concrete service
			for(int j=0; j<serviceMethodNames.get(i).size(); j++){
				if (!serviceMethodNames.get(i).get(j).equals("-")) { // test this is not a '-'
					if (a.length() > 0) { // this is not the first entry, so add a comma
						a = a + ", ";
						b = b + ", ";
						c = c + ", ";
					}

					String[] tmp = getArgList(proxyMethodSignatures.get(j)); 

					a = a + "\"" + tmp[1] + "\"";
					b = b + "0.45";
					c = c + "0.958";
				}
			}

			// Now we are ready to generate the code
			int v = i +1; 
			out.write("       // 3.3." + v + ". Instantiate service " + v);
			out.newLine();

			out.write("       methodNames = new String[] { " + a + " };");
			out.newLine();
			out.write("       costs = new double[] { " + b + " };");
			out.newLine();
			out.write("       aPrioriSuccessRates = new double[] { " + c + " };");
			out.newLine();
			out.write("       services[" + i + "] = new Service(methodNames, costs, aPrioriSuccessRates);");
			out.newLine();
			out.newLine();
		}

		out.write("       // 4. Instantiate the SLAs for the abstract methods, indices for the abstract methods and the last service index hashmap");
		out.newLine();
		out.write("       slas = new HashMap<String,MethodSLA>();");
		out.newLine();

		for(int i=0; i< proxyMethodSignatures.size(); i++){
			String [] str = getArgList( proxyMethodSignatures.get(i));
			out.write("       slas.put(\"" + str[1] + "\", new MethodSLA(0.0, Double.MAX_VALUE)); // anything is acceptable until the client tells otherwise");
			out.newLine();

		}

		out.write("	}");
		out.newLine();
		out.newLine(); 


		// 7. Generate one proxy method for each INTELLIGENT PROXY service method

		for (int i = 0; i < proxyMethodSignatures.size(); i++) { // i is the index of the method code is generated for
			String [] str = getArgList( proxyMethodSignatures.get(i));
			out.write("   // Abstract web method \"" + str[1] + "\" ");
			out.newLine();
			out.write("   public "  + proxyMethodSignatures.get(i) + " throws Exception {");
			out.newLine();	
			out.newLine();
			out.write("        //1. Update the model updater class");
			out.newLine();
			out.write("        model.nextInvocation(\"sendAlarm\");");
			out.newLine(); 
			out.newLine(); 
			out.write("       // 2. Remember index of used concrete service");
			out.newLine();
			out.write("      int serviceIndex = getServiceIndex(\"" + str[1] + "\");");
			out.newLine();
			out.newLine();
			out.write("      // 3. Local variable for result");
			out.newLine();
			out.write("           " +serviceMethodReturnType.get(i) +" result;");
			out.newLine();
			out.newLine();
			out.write("      // 4. Use the identified concrete service");
			out.newLine();
			out.write("      try{");
			out.newLine();
			out.write("         // 4.1. Invoke web method");
			out.newLine();
			out.write("         switch (serviceIndex) {");  
			out.newLine();

			// retrieve the array of stub class names

			int lastServiceThatHasMethod = 0;
			for(int j=1; j <= URLs.size(); j++) {
				if (!serviceMethodNames.get(j-1).get(i).equals("-")) {
					lastServiceThatHasMethod = j;
				}
			}

			for(int j=1; j <= URLs.size(); j++) { // j is the index of the web service

				String webMethodName = serviceMethodNames.get(j-1).get(i);
				if (webMethodName.equals("-")) {
					continue;
				}
				String className = stubNameFromWsdlUrl(URLs.get(j-1)) + "Stub";
				String webMethodNameUpperCase = serviceMethodNames.get(j-1).get(i);
				char[] stringArray = webMethodNameUpperCase.toCharArray();
				stringArray[0] = Character.toUpperCase(stringArray[0]);
				webMethodNameUpperCase = new String(stringArray);
				out.newLine();
				if (j<lastServiceThatHasMethod) {
					int j_minus_1 = j - 1;
					out.write("         case " + j_minus_1 + ": " );
				}
				else {
					out.write("         default:");
				}
				out.newLine();
				out.write("             //create the request");
				out.newLine();

				int numParam2 = serviceMethodParameters.get(i);
				if (numParam2 > 0){
					out.write("             " + className + "." + webMethodNameUpperCase + " request" + j  + " = new " + className +  "." + webMethodNameUpperCase + "();");
					out.newLine();	
					for(int r=0; r < numParam2; r++){
						out.write("             request" +j+".setArgs" + r + "(a" + r + ");");
						out.newLine();	
					}
					out.newLine();
					out.write("             //Invoke the service");
					out.newLine();
					out.write("             " + className + "." + webMethodNameUpperCase + "Response response" + j  +" = stub" +j  + "." + webMethodName + "(request"+j+");");

				}else
				{
					out.write("             //Invoke the service");
					out.newLine();
					out.write("             " + className + "." + webMethodNameUpperCase + "Response response" + j  +" = stub" +j  + "." + webMethodName + "();");

				}

				out.newLine();
				out.newLine();
				out.write("             // Return the result");
				out.newLine();
				out.write("             result = response"+ j + ".get_return();");
				out.newLine();		

				out.newLine();
				out.write("             // Done");
				out.newLine();
				out.write("             break;");
				out.newLine();		

			}
			out.newLine();	
			out.write("           }");
			out.newLine();	
			out.write("           // 4.2. Record success");
			out.newLine();
			out.write("           services[serviceIndex].recordSuccess(\"" + str[1] + "\");");
			out.newLine();
			out.newLine();
			out.write("           // 4.3 Return result");
			out.newLine();
			out.write("           return result;");
			out.newLine();
			out.newLine();
			out.write("        }");
			out.newLine();
			out.newLine();	
			out.write("        // 5. Handle exception");
			out.newLine();
			out.write("        catch (Exception ex){");
			out.newLine();
			out.newLine();
			out.write("           // 5.1 Log an error message");
			out.newLine();
			out.write("           System.out.println(ex.getMessage());");
			out.newLine();
			out.write("           logger.error(" + '"' + "Exception: " + '"' + " + ex.getMessage());");
			out.newLine(); 
			out.newLine();
			out.write("           // 5.2. Record failure ");
			out.newLine();
			out.write("           services[serviceIndex].recordFailure(\"" + str[1] + "\");");
			out.newLine();
			out.newLine();
			out.write("           // 5.3. Throw exception");
			out.newLine();
			out.write("           throw ex;");
			out.newLine();
			out.write("        }");
			out.newLine();
			out.newLine();
			out.write("    }");	
			out.newLine();
			out.newLine();
		}

		// 8. Write footer
		out.newLine();
		out.write("}");


		// 9. Close Java file
		out.close();
	}



	//execute System command line
	public static void executeCommand(String wsdlURL){

		deletefile(outputDir + "/build.xml");

		try {			
			Runtime rt = Runtime.getRuntime();

			String[] env2 = {JAVA_HOME, AXIS2_HOME}; 
			Process pr = rt.exec(w2jCommand + " -uri " + wsdlURL + " -o " + outputDir, env2);

			BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));

			String line=null;

			while((line=input.readLine()) != null) {
				System.out.println(line);
			}

			int exitVal = pr.waitFor();
			System.out.println("Exited with error code "+exitVal);

		} catch(Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
	}


	//execute 'ant' to copy the generated intelligent proxy .java file to relevant location
	public static void executeCommandAnt(){

		try {
			Runtime rt = Runtime.getRuntime();

			String[] env = {JAVA_HOME, AXIS2_HOME}; 

			File wdir = new File(outputDir);

			Process pr = rt.exec("ant",env,wdir);

			pr = rt.exec("mkdir " + outputDir + "/src/net/" + packageName);


			// 4. Generate the java file for intelligent proxy
			pr = rt.exec("cp " + outputDir + "/" + proxyName + ".java" + " "+ outputDir  +"/src/net/" + packageName + "/" + proxyName + ".java");


			BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));

			String line=null;

			while((line=input.readLine()) != null) {
				System.out.println(line);
			}

			int exitVal = pr.waitFor();
			System.out.println("Exited with error code "+exitVal);

		} catch(Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
	}

	// exectue 'ant' command to build the abstract services and create a single .jar file
	static private void generateStubs() {

		// Iterate over each web service URL
		for (int i = 0; i < URLs.size(); i++) {

			// Extract WSDL URL for web service i
			String wsdlUrl = URLs.get(i); //wsdlUrls.next();
			System.out.println(wsdlUrl);

			// Run axis2 on wsdlUrls[i] to generate stub for the i-th web service	
			executeCommand(wsdlUrl);	
		}

		// Run ant to package all stubs into a jar file
		executeCommandAnt();
	}

	//method to read the file structure and return the jar file identifier for import into java program
	static ArrayList<String> Process2(File aFile) {
		ArrayList<String> x = new ArrayList<String>();
		String thisDirectory = aFile.getName();
		File[] listOfFiles = aFile.listFiles();
		boolean hasSubdirectories = false;

		for (int i = 0; i < listOfFiles.length; i++) {
			if (listOfFiles[i].isDirectory()) {
				hasSubdirectories = true;
				ArrayList<String> b = Process2(listOfFiles[i]);
				for (int j = 0; j < b.size(); j++) {
					x.add(thisDirectory + "." + b.get(j));
				}
			}
		}

		if (!hasSubdirectories) {
			x.add(thisDirectory);
		}

		return x;
	}



	//method to read the directory structure and return the stub class
	static boolean interestingFile(String aFileName){
		return (aFileName.contains("Stub") && !aFileName.contains("$"));		
	}

	//method to read the given file director structure 
	static ArrayList<String> traverseDirectory(File node){
		ArrayList<String> fileNames = new ArrayList<String>();

		File[] listofFiles = node.listFiles();
		for(File aFile : listofFiles){
			if(aFile.isDirectory()){
				fileNames.addAll(traverseDirectory(aFile));			 
			}
			else{
				//check here to see if this is the file you want.			 
				if(interestingFile(aFile.getName())){
					String name = aFile.getName();
					int dot = name.lastIndexOf('.');
					String base = (dot == -1) ? name : name.substring(0, dot);
					fileNames.add(base);
				}
			}
		}
		return fileNames;	 
	}


	//
	// The tool parses a configuration file with details about the intelligent proxy
	// and generates n+1 jar files, where n>1 is the number of web services
	//
	//public static void main(String[] args) { //throws IOException{

	// excute the build proxy to generate the intelligent proxy .java file and the .jar file for the abstract services 
	public void exeBuildProxy(){

		parseConfigEnv("envConfig.txt"); 

		try {


			// 1. Create output directory
			outputDir = System.getProperty("user.dir") + "/proxy";
			System.out.println("Code generated in " + outputDir);


			// 2. Read config file
			parseConfig( System.getProperty("user.dir") + "/config.temp");


			// 3. Generate intelligent proxy
			try {
				generateIntelligentProxy();
			}
			catch (Exception e) {
				;
			}

			// 6. Generate the stubs for the n web services and compile the .java files and
			//     generate a single jar file 

			generateStubs();


		} catch(Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}

	}
}

