/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package gui;

import holtjp.proxygen.webservice.Parameter;
import holtjp.proxygen.webservice.WebServiceMethod;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;

import javax.swing.JLabel;

public class AddNewProxyMethodDialog extends JDialog {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final JTextField methName;
	private final JTextField params;
	private final JTextField retType;

	private AddNewProxyMethodDialog self = this;

	public AddNewProxyMethodDialog(JFrame parent,final GUI gui){
		super(parent,Dialog.ModalityType.APPLICATION_MODAL);


		setPreferredSize(new Dimension(500,150));
		setLayout(new GridLayout(4,2,5,5));

		add(new JLabel("Abstract operation name:"));
		methName = new JTextField();
		add(methName);

		add(new JLabel("Parameters:"));
		params= new JTextField();
		add(params);

		add(new JLabel("Return type"));
		retType = new JTextField("void");
		add(retType);

		JButton b = new JButton("Add");
		b.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				if(methName.getText().length() > 0){
					Parameter[] par = new Parameter[0];
					if(params.getText().length()> 0){
						String[] p = params.getText().split("\\,");
						par = new Parameter[p.length];
						int i = 0;
						for(String pp : p){
							par[i] = new Parameter(pp.split(" ")[0], pp.split(" ")[1]);
							i++;
						}
					}
					gui.model.addProxyMethod(new WebServiceMethod(null,
							methName.getText()
							, retType.getText().length() > 0 ? retType.getText() : "void"  
									, par));
					self.setVisible(false);    
				}

			}
		});
		add(b);
		pack();

	}
}
