/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package gui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;

import javax.swing.JLabel;
import java.io.*;

public class AddNewProxyPackageNameDialog extends JDialog {


	/**
	 * 
	 */
	private static final long serialVersionUID = 3L;
	private final JTextField packageName;
	private AddNewProxyPackageNameDialog self = this;

	public AddNewProxyPackageNameDialog(JFrame parent,final GUI gui){
		super(parent,Dialog.ModalityType.APPLICATION_MODAL);


		setPreferredSize(new Dimension(500,150));
		setLayout(new GridLayout(4,2,5,5));

		add(new JLabel("package name:"));
		packageName = new JTextField();
		add(packageName);

		JButton b = new JButton("Add");
		b.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				if(packageName.getText().length() > 0){

					gui.model.addProxyPackageName(packageName.getText());

					try{

						upDateFiles("Method.txt", "Method.java", packageName.getText());
						upDateFiles("MethodSLA.txt", "MethodSLA.java", packageName.getText());
						upDateFiles("Service.txt", "Service.java", packageName.getText());
						upDateFiles("TransitionProbability.txt", "TransitionProbability.java", packageName.getText());

					}catch (Exception io){

					}

				}
				self.setVisible(false); 
			}

		});
		add(b);
		pack();

	}

	private void upDateFiles(String F1, String F2, String pName) throws Exception {
		File f1 = new File(F1);
		File f2 = new File(F2);

		try{
			f2.delete(); 
			FileWriter fstream = new FileWriter(f2,true);
			BufferedWriter out2 = new BufferedWriter(fstream);
			out2.write("package " +packageName.getText() + ";");
			out2.newLine();
			out2.newLine();
			out2.close(); 
		}catch (Exception e){

		}

		InputStream in = null;
		OutputStream out = null;
		try {

			in = new FileInputStream(f1);
			out = new FileOutputStream(f2, true);

			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0) {
				out.write(buf, 0, len);
			}
		} finally {
			if (out != null) {
				out.close();
			}
			if (in != null) {
				in.close();
			}
		}
	}

}
