/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package gui;

import holtjp.proxygen.webservice.WebService;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.*;

public class ConcreteServicePanel  extends JPanel {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1365536146241488827L;
	final DefaultListModel dlm = new DefaultListModel();
	private final Map<String,WebService> webServices;


	public ConcreteServicePanel(final GUI gui, final JList mapList, JButton loadWsdl, JButton addMapping, JButton removeMapping, final JList wsdlMethodList, JButton ex){

		super(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		webServices = new HashMap<String, WebService>();
		JComponent l;

		//Header label
		l = new JLabel("Concrete Services ");
		Font font = l.getFont();
		l.setFont(new Font(font.toString(), Font.PLAIN, 20));
		c.gridx = 0;
		c.gridy = 0;
		c.anchor = GridBagConstraints.LINE_END;  
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 1;
		c.anchor = GridBagConstraints.LINE_END;  
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = new JLabel("Concrete service URLs ");
		c.gridx = 0;
		c.gridy = 3;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = loadWsdl;
		l.setPreferredSize(new Dimension(20,20));
		c.gridx = 8;
		c.gridy = 3;
		c.anchor = GridBagConstraints.LINE_END;  
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = new JButton("-");
		l.setPreferredSize(new Dimension(20,20));
		c.gridx = 9;
		c.gridy = 3;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = mapList;
		l.setPreferredSize(new Dimension(500,100));
		c.gridx = 0;
		c.gridy = 4;
		c.gridwidth = 8;
		c.anchor = GridBagConstraints.LINE_END;
		c.anchor = GridBagConstraints.NORTHWEST;       
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 5;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);


		l = new JLabel("Concrete service operations ");
		c.gridx = 0;
		c.gridy = 6;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST; 
		add(l,c);

		l = addMapping;
		l.setPreferredSize(new Dimension(21,21));
		c.gridx = 8;
		c.gridy = 6;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST; 
		add(l,c);

		l = removeMapping;
		l.setPreferredSize(new Dimension(21,21));
		c.gridx = 9;
		c.gridy = 6;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHEAST; 
		add(l,c);


		l = wsdlMethodList;
		l.setPreferredSize(new Dimension(500,300));
		c.gridx = 0;
		c.gridy = 7;
		c.gridwidth = 8;
		c.anchor = GridBagConstraints.LINE_END;
		c.anchor = GridBagConstraints.NORTHWEST; 
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 9;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);

		l = ex;
		l.setPreferredSize(new Dimension(50,50));
		c.gridx = 10;
		c.gridy = 10;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);


	}

}
