/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package gui;

import holtjp.proxygen.proxy.ProxyModel;
import holtjp.proxygen.proxy.WebServiceMap;
import holtjp.proxygen.webservice.Parameter;
import holtjp.proxygen.webservice.WebService;
import holtjp.proxygen.webservice.WebServiceMethod;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


public class GUI extends JFrame{

	private static final long serialVersionUID = 1L;
	final ProxyModel model = new ProxyModel();

	private final GUI gui;

	// The list of WSDL URLs
	private final JList mapList;

	final DefaultListModel dlm = new DefaultListModel();

	final JList proxyMethodList;
	final JList wsdlMethodList;

	private final Map<String,WebService> webServices;

	public GUI(){

		// 1. Initialise main frame and menu bar
		super("Proxygen");
		gui = this;
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setLayout(new BorderLayout());
		setPreferredSize(new Dimension(1350,650));

		// 1'. 
		webServices = new HashMap<String, WebService>();


		//---- MAIN GUI BEGIN

		// 2. Configure main layout for the Intelligent Proxy & Concrete Services panels 
		Panel lists = new Panel();
		lists.setLayout(new GridLayout(1,3,5,5));

		// 3. Assemble Intelligent Proxy panel on the left-hand side of GUI

		// 3.1. Create add and remove abstract operation buttons
		ImageIcon add = new ImageIcon("images/add.gif");
		JButton jb1 = new JButton(add);
		jb1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {
				new AddNewProxyMethodDialog(gui,gui).setVisible(true);
			}
		});

		ImageIcon delete = new ImageIcon("images/del.gif");
		JButton jb2 = new JButton(delete);
		jb2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {
				int idx = proxyMethodList.getSelectedIndex();
				System.out.println("remove fired with idx " + idx);
				if(idx >= 0 && idx < model.getSize()){
					proxyMethodList.clearSelection();
					WebServiceMethod m = (WebServiceMethod) model.getElementAt(idx);
					model.removeProxyMethod(m.getOperationName());
				}

			}
		});

		// 3.2. create list for proxy's methods
		proxyMethodList = new WebServiceMethodList(model,true);
		proxyMethodList.addListSelectionListener(new ListSelectionListener() {

			@Override
			public void valueChanged(ListSelectionEvent event) {
				rebuildMappingList();
			}
		});

		//3.3 add generate proxy button
		JButton proxyGen = new JButton("Generate Proxy");
		jb2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {

			}
		});

		// 3.4. create the Intelligent Proxy (aka "proxy name panel")
		final WebServiceNamePanel proxyNamePanel = 
			new WebServiceNamePanel(gui, jb1, jb2, proxyMethodList, proxyGen); 

		// 3.5. create and configure proxy model column
		JPanel proxyColumn = new JPanel(new GridLayout(4,1,5,0));
		proxyColumn.setLayout(new BorderLayout());

		proxyColumn.add(proxyNamePanel, BorderLayout.NORTH);
		lists.add(proxyColumn);

		// 4. Assemble the Concrete Services panel on the right-hand side of the GUI
		// 4.1. Create add (and soon remove) WSDL URL buttons for the concrete services
		ImageIcon add2 = new ImageIcon("images/add.gif");
		JButton loadWsdl2 = new JButton(add2);
		loadWsdl2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {
				System.out.println("* before *" + mapList.getModel().getSize() + " elements");
				new LoadNewWsdlDialog(gui, gui).setVisible(true);				
				System.out.println("**" + mapList.getModel().getSize() + " elements");
				System.out.println("** Element 1 is " + mapList.getModel().getElementAt(0));
				System.out.println("** Element 1 is a " + mapList.getModel().getElementAt(0).getClass().getCanonicalName());
			}
		});

		// 4.2. Create the proxy mapping list
		mapList = new WebServiceMethodList(dlm, false);
		mapList.addListSelectionListener(new ListSelectionListener() {

			@Override
			public void valueChanged(ListSelectionEvent event) {
				System.out.println("Selection changed");//DEBUG
				if(mapList.getSelectedIndex() == -1){return;}
				WebServiceMethod m = (WebServiceMethod) dlm.getElementAt(mapList.getSelectedIndex());
				System.out.println(m.getUrl());

				WebService ws = webServices.get(m.getUrl());

				if(ws != null){
					System.out.println("Changing model");//DEBUG
					wsdlMethodList.setModel(ws);
				}
			}
		});

		// 4.3. Create link and unlink buttons for mapping abstract operations to concrete web service methods
		ImageIcon link = new ImageIcon("images/link.gif");
		JButton addToMap = new JButton(link);
		addToMap.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {
				if( wsdlMethodList.getSelectedIndex() < 0){return;}
				if( proxyMethodList.getSelectedIndex() < 0){return;}

				//get selected concrete method
				WebServiceMethod m = (WebServiceMethod) wsdlMethodList.getModel().getElementAt(wsdlMethodList.getSelectedIndex());
				//get selected proxy method
				WebServiceMethod pm = (WebServiceMethod) proxyMethodList.getModel().getElementAt(proxyMethodList.getSelectedIndex());

				model.mapRealMethod(pm.getOperationName(), m);
				rebuildMappingList();
			}
		});

		ImageIcon unlink = new ImageIcon("images/unlink2.gif");
		JButton removeMapping = new JButton(unlink);
		removeMapping.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {
				// TODO Auto-generated method stub
				if(mapList.getSelectedIndex()<0){return;}
				if(proxyMethodList.getSelectedIndex()<0){return;}

				WebServiceMethod m = (WebServiceMethod) dlm.get(mapList.getSelectedIndex());
				WebServiceMethod pm = (WebServiceMethod) proxyMethodList.getModel().getElementAt(proxyMethodList.getSelectedIndex());
				model.removeMapping(pm.getOperationName(), m.getUrl());
				rebuildMappingList();
			}
		});

		//5.2 add exit application button
		JButton exitButton = new JButton("Exit");
		jb2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent event) {

			}
		});


		// 4.4 Create the list of concrete service methods
		wsdlMethodList = new WebServiceMethodList(new DefaultListModel(),true);

		// 4.4. create and configure Concrete Services column
		JPanel proxyMapcolumn = new JPanel(new BorderLayout());
		final ConcreteServicePanel concreteServicePanel = 
			new ConcreteServicePanel(gui, mapList, loadWsdl2, addToMap, removeMapping, wsdlMethodList, exitButton); 
		proxyMapcolumn.add(concreteServicePanel,BorderLayout.NORTH);        
		lists.add(proxyMapcolumn);

		// 4.5. wire list to panel
		proxyMethodList.addListSelectionListener(new WebServiceMethodListListener(proxyMethodList, concreteServicePanel));
		wsdlMethodList.addListSelectionListener(new WebServiceMethodListListener(wsdlMethodList, concreteServicePanel));


		// 5. Finish up, pack it, ship it
		add(lists,BorderLayout.CENTER);
		add(new MenuBar(this),BorderLayout.NORTH);
		pack();
		setVisible(true);

	}

	public static void main(String[] args){
		javax.swing.SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				new GUI();

			}
		});
	}

	public void addNewWebService(WebService ws){
		webServices.put(ws.getURL(), ws);
		model.makeMap(ws.getURL());
		rebuildMappingList();
	}

	private void rebuildMappingList(){
		if(proxyMethodList.getSelectedIndex() == -1){dlm.clear();return;}
		WebServiceMethod m = (WebServiceMethod) model.getElementAt(proxyMethodList.getSelectedIndex());

		if(m!=null){
			dlm.clear();//clear mapping list
			Iterator<WebServiceMap> it = model.getProxyMapIterator();
			while(it.hasNext()){
				//repopulate mapping list
				WebServiceMap wsm = it.next();
				if(wsm.getMapped(m.getOperationName()) !=null){
					dlm.addElement(wsm.getMapped(m.getOperationName()));
				}else
				{
					dlm.addElement(new WebServiceMethod(
							wsm.getURL(), 
							"-", 
							"", 
							new Parameter[0]));
				}
			}
		}

	}
}