/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import buildIntelligentProxy.BuildProxy; 

public class MenuBar extends JMenuBar {

	/**
	 * 
	 */
	JMenuItem _generate;

	private static final long serialVersionUID = 1L;

	private final JFileChooser fileChoose = new JFileChooser();
	public MenuBar(final GUI gui){
		JMenu file = new JMenu("File");

		//New Button
		JMenuItem _new = new JMenuItem("New");
		_new.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent a) {
				gui.model.reset();
				gui.proxyMethodList.setModel(gui.model);
				gui.dlm.clear();
				gui.wsdlMethodList.setListData(new Object[0]);
				System.out.println("New clicked! " + a.getActionCommand());
			}
		});
		file.add(_new);


		//New Button
		JMenuItem _open = new JMenuItem("Open");
		_open.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent a) {

				System.out.println("Open clicked! " + a.getActionCommand());
			}
		});
		file.add(_open);

		//New Button
		JMenuItem _save = new JMenuItem("Save");
		_save.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent a) {
				int ret = fileChoose.showSaveDialog(gui);
				if(ret == JFileChooser.APPROVE_OPTION){
					File f = fileChoose.getSelectedFile();
					try {
						f.createNewFile();
						DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));

						dos.writeBytes(gui.model.toString());
						dos.flush();
						dos.close();
					} catch (FileNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}

				}
			}
		});
		file.add(_save);

		//New Button
		_generate = new JMenuItem("Generate");
		_generate.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent a) {

				System.out.println("Generate clicked! " + a.getActionCommand());

				try {
					File f = new File("config.temp"); 
					f.createNewFile();
					DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));

					dos.writeBytes(gui.model.toString());
					dos.flush();
					dos.close();
				} catch (FileNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				runCC();
				try {
					Thread.sleep(3000);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				runCC(); 
			}
		});	

		file.add(_generate);
		add(file);
	}

	public void runCC()
	{
		BuildProxy sim = new BuildProxy();
		sim.exeBuildProxy();
	}

	public void doClick(){

		_generate.doClick();
	}
}
