/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package gui;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.swing.*;

import buildIntelligentProxy.BuildProxy;

public class WebServiceNamePanel extends JPanel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final JTextField className;
	private final JTextField packageName;
	private final JButton Gen; 

	public WebServiceNamePanel(final GUI gui, JButton b1, JButton b2, final JList proxyMethodList, JButton gen){
		super(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints(); 
		className = new JTextField(15);
		packageName = new JTextField(15); 
		JComponent l;

		//Header label
		l = new JLabel("Intelligent Proxy ");
		Font font = l.getFont();
		l.setFont(new Font(font.toString(), Font.PLAIN, 20));
		c.gridx = 0;
		c.gridy = 0;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);


		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 1;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 2;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);


		l = new JLabel("Intelligent Proxy Name: ");
		c.gridx = 0;
		c.gridy = 3;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		String text = "MyProxy";
		className.setText(text);        
		c.gridx = 1;
		c.gridy = 3;
		c.gridwidth = 6;
		c.anchor = GridBagConstraints.LINE_START;
		c.anchor = GridBagConstraints.NORTHWEST;
		add(className,c);


		l = new JLabel("Java Package Name: ");
		c.gridx = 0;
		c.gridy = 4;
		c.gridwidth = 1;
		c.anchor = GridBagConstraints.LINE_END;
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		String text2 = "myProxyPkg";
		packageName.setText(text2);

		c.gridx = 1;
		c.gridy = 4;
		c.gridwidth = 6;
		c.anchor = GridBagConstraints.LINE_START;
		c.anchor = GridBagConstraints.NORTHWEST;
		add(packageName,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 5;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 6;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 7;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 8;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);

		l = new JLabel("Abstract Operations ");
		c.gridx = 0;
		c.gridy = 9;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = b1;
		l.setPreferredSize(new Dimension(20,20));
		c.gridx = 9;
		c.gridy = 9;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = b2;
		l.setPreferredSize(new Dimension(20,20));
		c.gridx = 15;
		c.gridy = 9;
		c.anchor = GridBagConstraints.LINE_END; 
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = proxyMethodList;
		l.setPreferredSize(new Dimension(500,300));
		c.gridx = 0;
		c.gridy = 10;
		c.gridwidth = 9;
		c.anchor = GridBagConstraints.LINE_END;
		c.anchor = GridBagConstraints.NORTHWEST;
		add(l,c);

		l = new JLabel(" ");
		c.gridx = 0;
		c.gridy = 11;
		c.anchor = GridBagConstraints.LINE_END;        
		add(l,c);


		Gen = new JButton("Generate Proxy"); //gen;
		Gen.setPreferredSize(new Dimension(150,50));
		c.gridx = 13;
		c.gridy = 12;
		c.gridwidth = 5;
		c.anchor = GridBagConstraints.LINE_END;        
		Gen.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent a) {

				if(className.getText().length() > 0){

					gui.model.addProxyClassName(className.getText());
				}

				if(packageName.getText().length() > 0){

					gui.model.addProxyPackageName(packageName.getText());

					try{

						upDateFiles("Method.txt", "Method.java", packageName.getText());
						upDateFiles("MethodSLA.txt", "MethodSLA.java", packageName.getText());
						upDateFiles("Service.txt", "Service.java", packageName.getText());
						upDateFiles("TransitionProbability.txt", "TransitionProbability.java", packageName.getText());

					}catch (Exception io){

					}
				}

				System.out.println("Generate clicked! " + a.getActionCommand());

				try {
					File f = new File("config.temp"); 
					f.createNewFile();
					DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));

					dos.writeBytes(gui.model.toString());
					dos.flush();
					dos.close();
				} catch (FileNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				runCC();

				try {
					Thread.sleep(3000);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				runCC(); 
			}
		});
		add(Gen,c);

	}

	public void runCC()
	{
		BuildProxy sim = new BuildProxy();
		sim.exeBuildProxy();
		//sim.exeBuildProxy();
	}

	public void doClick(){

		Gen.doClick();
	}


	private void upDateFiles(String F1, String F2, String pName) throws Exception {
		File f1 = new File(F1);
		File f2 = new File(F2);

		try{
			f2.delete(); 
			FileWriter fstream = new FileWriter(f2,true);
			BufferedWriter out2 = new BufferedWriter(fstream);
			out2.write("package " +packageName.getText() + ";");
			out2.newLine();
			out2.newLine();
			out2.close(); 
		}catch (Exception e){

		}

		InputStream in = null;
		OutputStream out = null;
		try {

			in = new FileInputStream(f1);
			out = new FileOutputStream(f2, true);

			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0) {
				out.write(buf, 0, len);
			}
		} finally {
			if (out != null) {
				out.close();
			}
			if (in != null) {
				in.close();
			}
		}
	}


}
