/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package holtjp.proxygen.gui.cellRenderers;

import holtjp.proxygen.webservice.Parameter;
import holtjp.proxygen.webservice.WebServiceMethod;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;



public class WebServiceMethodRenderer extends JPanel implements ListCellRenderer{
	private static final long serialVersionUID = 1L;
	JLabel label1;
	JLabel label2;
	boolean mode; // mode = true: output method signature; mode = false: output URL or web service

	public WebServiceMethodRenderer(boolean mode){
		setLayout(new GridLayout(2,1));
		this.mode = mode;
		setBackground(Color.WHITE);

		label1 = new JLabel();
		label2 = new JLabel();
		add(label1);
		add(label2);
	}

	@Override
	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {

		WebServiceMethod method = (WebServiceMethod)value;

		if (mode) {

			String methodName = method.getOperationName();
			String returnType = method.getReturnType();

			Parameter [] parameters = method.getParameters();
			String ret = methodName + "(";
			boolean p = false;

			for(Parameter param: parameters){
				if(p){
					ret += ", ";
				}else{p=true;}
				ret += param;
			}

			ret = ret + ") : " + returnType;

			label1.setText(ret);
			setToolTipText(method.toString());
			label2.setText("");
		}

		else {
			label1.setText(method.getUrl());
			String methodName = method.getOperationName();
			label2.setText("  --> " + (methodName.equals("-") ? "no concrete method associated with the selected abstract operation" : "selected abstract operation mapped to " + methodName));
		}

		setBackground(isSelected ? new Color(0.8f,0.8f,1.0f) : Color.WHITE);

		return this;
	}

}
