/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package holtjp.proxygen.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractListModel;


import holtjp.proxygen.webservice.WebServiceMethod;


public class ProxyModel extends AbstractListModel {

	private static final long serialVersionUID = -3015484160709406717L;
	String packageName = "";
	String className = "";
	List<WebServiceMap> webServiceMaps = new ArrayList<WebServiceMap>();
	List<WebServiceMethod> methods = new ArrayList<WebServiceMethod>();

	/**
	 * Create a new proxy model for generating a proxy class
	 * @param packageName package name of generated class
	 * @param className name of generated class
	 */
	public ProxyModel() {

	}

	public void addProxyClassName(String className){

		this.className = className; 
	}

	public void addProxyPackageName(String packageName){
		this.packageName = packageName; 
	}

	public void reset(){
		webServiceMaps.clear();
		methods.clear();
	}
	/**
	 * Add a method for the proxy
	 * @param method method to add to the proxy
	 */
	public void addProxyMethod(WebServiceMethod method){
		methods.add(method);
		fireIntervalAdded(this, methods.size(), methods.size());
		for(WebServiceMethod m : methods){
			System.out.println(m.toString());
		}
	}

	public void removeProxyMethod(String opName){
		Iterator<WebServiceMethod> it = methods.iterator();
		int i = 0;
		while(it.hasNext()){

			WebServiceMethod m = it.next();
			if(m.getOperationName().equals(opName)){
				it.remove();
				break;
			}
			i++;
		}

		for(WebServiceMap map : webServiceMaps){
			map.unMap(opName);
		}
		fireIntervalRemoved(this, i,i);
	}

	/**
	 * Map a real WebServiceMethod to a proxy method
	 * @param mapTo proxy method to map
	 * @param url url of this webServiceMethod
	 * @param method method to add
	 */
	public void mapRealMethod(String mapTo,WebServiceMethod method){
		String url = method.getUrl();
		for(WebServiceMethod pmethod : methods){
			if(pmethod.getOperationName().equals(mapTo)){
				makeMap(url);
				getMappingFor(url).mapTo(mapTo, method);
				return;
			}
		}
	}

	/**
	 * Create a new map
	 * @param url
	 */
	public void makeMap(String url){
		for(WebServiceMap map : webServiceMaps){
			if(map.getURL().equals(url)){return;}
		}
		webServiceMaps.add(new WebServiceMap(url));
	}

	/**
	 * Retrieve the Mapping data for a particular webService URL
	 * @param url
	 * @return
	 */
	public WebServiceMap getMappingFor(String url){
		for(WebServiceMap map : webServiceMaps){
			if(map.getURL().equals(url)){return map;}
		}
		return null;
	}

	public void removeMapping(String proxyMethod,String url){
		WebServiceMap wsm = getMappingFor(url);
		if(wsm!=null){
			wsm.unMap(proxyMethod);
		}
	}


	/**
	 * Iterator for proxy methods
	 * @return
	 */
	public Iterator<WebServiceMethod> getProxyMethodIterator(){
		return methods.iterator();
	}

	/**
	 * Iterator for web service maps
	 * @return
	 */
	public Iterator<WebServiceMap> getProxyMapIterator(){
		return webServiceMaps.iterator();
	}


	/**
	 * Returns information on proxy model in
	 * proxy generator compatible format.
	 */
	public String toString(){
		String ret = className+ "\n";
		ret +=  packageName + "\n";
		for(WebServiceMethod m : methods){
			ret += m.toString() + "\n";
		}

		for(WebServiceMap map :webServiceMaps){
			ret += "\n";
			ret += map.getURL() +"\n";
			for(WebServiceMethod m : methods){
				WebServiceMethod method = map.getMapped(m.getOperationName());

				if(method == null){
					ret += "-\n";
				}
				else
				{
					ret += method.getOperationName() + "\n";
				}

			}
		}


		return ret;
	}

	@Override
	public Object getElementAt(int arg0) {
		return methods.get(arg0);
	}

	@Override
	public int getSize() {
		return methods.size();
	}




}
