/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package holtjp.proxygen.proxy;

import holtjp.proxygen.webservice.WebServiceMethod;

import java.util.HashMap;


public class WebServiceMap {

	private String url;
	private HashMap<String,WebServiceMethod> mapping = new HashMap<String, WebServiceMethod>();

	/**
	 * Construct a new web service map for this URL
	 * @param url
	 */
	public WebServiceMap(String url){
		this.url = url;
	}

	/**
	 * get URL associated with this map
	 * @return
	 */
	public String getURL(){
		return url;
	}
	/**
	 * Map a web service method to a pseudo name
	 * @param methodName
	 * @param method
	 */
	public void mapTo(String methodName,WebServiceMethod method){
		mapping.put(methodName, method);
	}


	public void unMap(String proxyMethod){
		mapping.remove(proxyMethod);
	}

	/**
	 * Return the webservice method this method name is mapped to
	 * @param method WebServiceMethod object or null if none found
	 * @return the web service method associated with a mapping
	 */
	public WebServiceMethod getMapped(String method){
		if(!mapping.containsKey(method)){return null;}
		return mapping.get(method);
	}
}
