/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package holtjp.proxygen.webservice;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.*;

import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.api.WSDLException;


public class EasyWSDLWebService extends WebService {


	private static final long serialVersionUID = 6722051196997923701L;

	public EasyWSDLWebService(){

	}

	public void load(URL url){
		this.url = url.toString();
		methods.clear();
		try {
			debug("Reading wsdl");
			long t = System.currentTimeMillis();
			Description desc = WSDLFactory.newInstance().newWSDLReader().read(url);

			debug("Time to parse wsdl, " + (System.currentTimeMillis() - t) + " milliseconds");
			for(InterfaceType iface : desc.getInterfaces()){
				debug("Parsing " + iface.getOperations().size() + " operations");
				for(Operation op :iface.getOperations()){


					ParameterList params = new ParameterList();
					for(Part param : op.getInput().getParts()){
						params.addList(parseSimpleTypes(param.getElement()));
					}

					ParameterList returnType = new ParameterList();
					for(Part param : op.getOutput().getParts()){
						returnType .addList(parseSimpleTypes(param.getElement()));
					}
					String rt = "void";
					if(returnType.size() == 1){
						rt = returnType.toArray()[0].getType();
					}
					else if (returnType.size() > 1)
					{
						rt = "Map<String,Object>";
						rt = "string";
					}

					//old return type op.getOutput().getElement().getQName().getLocalPart()
					methods.add(new WebServiceMethod(
							url.toString(),
							op.getQName().getLocalPart(),
							rt,
							params.toArray())
					);
				}
			}
		} catch (WSDLException e) {
			System.out.println("Could not parse the supplied WSDL file");
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println("Could not access the supplied WSDL file");
			e.printStackTrace();
		} catch (URISyntaxException e) {
			System.out.println("Could not use supplied URL for WSDL");
			e.printStackTrace();
		}
	}


	private void debug(String string) {
		System.out.println(string);
	}

	private ParameterList parseSimpleTypes(Element e){
		return parseSimpleTypes(e,"");
	}

	/**
	 * Parse a supplied element to generate a list types and names for a parameter list
	 * @param e Element to parse
	 * @param prefix prefix to apply 
	 */
	private ParameterList parseSimpleTypes(Element e, String prefix){
		Type t = e.getType();
		ParameterList params = new ParameterList();
		if(t instanceof ComplexType){
			ComplexType ct = (ComplexType) t;
			if(ct.hasSequence()){
				for(Element seqE : ct.getSequence().getElements()){
					params.addList(parseSimpleTypes(seqE, e.getQName().getLocalPart()));
				}
			}
			else if(ct.hasComplexContent()){

				//TODO: SUPPORT THESE
				//throw new UnsupportedOperationException("Parsing of complex content is not available in this build");
			}
			else if(ct.hasSimpleContent()){
				//throw new UnsupportedOperationException("Parsing of simple content is not available in this build");

			}else if(ct.hasChoice()){
				//throw new UnsupportedOperationException("Parsing of choice is not available in this build");
			}


		}else
		{
			//This is a simple element
			params.add(t.getQName().getLocalPart(), prefix + "." + e.getQName().getLocalPart());
		}


		return params;
	}

	private class ParameterList {
		private List<Parameter> params;

		public ParameterList() {
			params = new ArrayList<Parameter>();

		}

		public void addList(ParameterList a){
			params.addAll(a.params);
		}


		public void add(String t,String n){
			params.add(new Parameter(t, n));
		}

		private Parameter[] toArray(){
			Parameter[] r = new Parameter[params.size()];
			int i = 0;
			for(Parameter s : params){
				r[i] = s;
				i++;
			}
			return r;

		}
		private int size(){
			return params.size();
		}
	}

}
