/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

package holtjp.proxygen.webservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLWebService extends WebService {


	private static final long serialVersionUID = 1L;

	public WSDLWebService(InputStream stream) throws SAXException, IOException, ParserConfigurationException{
		super();
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		Document doc =  dbFactory.newDocumentBuilder().parse(stream);

		XPath xPath = XPathFactory.newInstance().newXPath();


		try {

			XPathExpression inputExp = xPath.compile("./input");
			XPathExpression outputExp = xPath.compile("./output");


			if(xPath.compile("description").evaluate(doc, XPathConstants.NODE)!=null){
				System.out.println("WSDL 2.0");//DEBUG
				NodeList operations = (NodeList) xPath.compile("/description/interface/operation").evaluate(doc, XPathConstants.NODESET);
				if(operations.getLength() > 0){
					for(int i = 0;i<operations.getLength();i++){
						Node operation = operations.item(i);
						String opName = operation.getAttributes().getNamedItem("name").getNodeValue();


						//read input node
						Node inp = (Node) inputExp.evaluate(operation, XPathConstants.NODE);

						//Retrieve the message type for input
						String elementInput = inp.getAttributes().getNamedItem("element").getNodeValue().split(":")[1];

						List<String> arguments = new ArrayList<String>();
						List<String> argumentTypes = new ArrayList<String>();

						NodeList inputSchemaNode = (NodeList) xPath.compile("/description/types/schema/element[@name='" + elementInput + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);

						for(int k = 0;k<inputSchemaNode.getLength();k++){
							Node partElement = inputSchemaNode.item(k);
							arguments.add(partElement.getAttributes().getNamedItem("name").getNodeValue());
							argumentTypes.add(partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1]);
						}



						//read input node
						Node out = (Node) outputExp.evaluate(operation, XPathConstants.NODE);

						//Retrieve the message type for input
						String elementOutput = out.getAttributes().getNamedItem("element").getNodeValue().split(":")[1];

						//grab the list of paramaters in a message

						NodeList outputSchemaNode = (NodeList) xPath.compile("/description/types/schema/element[@name='" + elementOutput + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);

						for(int k = 0;k<outputSchemaNode.getLength();k++){
							Node partElement = outputSchemaNode.item(k);
							elementOutput = partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1];
						}

						Parameter[] p = new Parameter[arguments.size()];
						for(int ii = 0 ; ii < p.length; ii ++){
							p[ii] = new Parameter(argumentTypes.get(ii),arguments.get(ii));

						}


						methods.add(new WebServiceMethod("test.url.ignore.com",opName, elementOutput,p));

					}
				}

			}
			else
			{
				System.out.println("WSDL 1.0");//DEBUG
				NodeList operations = (NodeList) xPath.compile("/definitions/portType/operation").evaluate(doc, XPathConstants.NODESET);
				if(operations.getLength() > 0){
					System.out.println(operations.getLength());
					for(int i = 0;i<operations.getLength();i++){
						Node operation = operations.item(i);
						String opName = operation.getAttributes().getNamedItem("name").getNodeValue();


						//read input node
						Node inp = (Node) inputExp.evaluate(operation, XPathConstants.NODE);

						//Retrieve the message type for input
						String messageInput = inp.getAttributes().getNamedItem("message").getNodeValue().split(":")[1];

						//Get the related XSchema declaration
						Node parameter = (Node) xPath.compile("/definitions/message[@name='" + messageInput + "']/part").evaluate(doc, XPathConstants.NODE);

						List<String> arguments = new ArrayList<String>();
						List<String> argumentTypes = new ArrayList<String>();
						if(parameter !=null){
							String inpSchemaName = parameter.getAttributes().getNamedItem("element").getNodeValue().split("\\:")[1];

							NodeList inputSchemaNode = (NodeList) xPath.compile("/definitions/types/schema/element[@name='" + inpSchemaName + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);

							for(int k = 0;k<inputSchemaNode.getLength();k++){
								Node partElement = inputSchemaNode.item(k);
								arguments.add(partElement.getAttributes().getNamedItem("name").getNodeValue());
								argumentTypes.add(partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1]);
							}
						}


						//read input node
						Node out = (Node) outputExp.evaluate(operation, XPathConstants.NODE);

						//Retrieve the message type for input
						String messageOutput = out.getAttributes().getNamedItem("message").getNodeValue().split(":")[1];

						//grab the list of paramaters in a message
						parameter = (Node) xPath.compile("/definitions/message[@name='" + messageOutput + "']/part").evaluate(doc, XPathConstants.NODE);
						String schemaOutput = "";
						if(parameter !=null){
							String outSchemaName = parameter.getAttributes().getNamedItem("element").getNodeValue().split("\\:")[1];

							NodeList outputSchemaNode = (NodeList) xPath.compile("/definitions/types/schema/element[@name='" + outSchemaName + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);

							for(int k = 0;k<outputSchemaNode.getLength();k++){
								Node partElement = outputSchemaNode.item(k);
								schemaOutput = partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1];
							}
						}

						Parameter[] p = new Parameter[arguments.size()];
						for(int ii = 0 ; ii < p.length; ii ++){
							p[ii] = new Parameter(argumentTypes.get(ii),arguments.get(ii));

						}

						methods.add(new WebServiceMethod("test.url.ignore.com",opName, schemaOutput,p));

					}
				}

			}
		} catch (XPathExpressionException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void load(URL url) {
		// TODO Auto-generated method stub

	}

}
