/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package holtjp.proxygen.webservice;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;


public abstract class WebService extends AbstractListModel {

	private static final long serialVersionUID = 5692656211017107851L;
	protected String url;
	protected final List<WebServiceMethod> methods;


	public WebService(){
		methods = new ArrayList<WebServiceMethod>();
	}

	public abstract void load(URL url);
	/**
	 * Retrieve a method from this web service
	 * @param i
	 * @return
	 */
	public WebServiceMethod getMethod(int i){
		if(i<0 || i >= methods.size()){throw new IllegalArgumentException("index specified is outside of range 0-" + getSize());}
		return methods.get(i);
	}

	/**
	 * Retrieve the method associated with this operations name
	 * @param operationName
	 * @return
	 */
	public WebServiceMethod getMethod(String operationName){
		for(WebServiceMethod method:methods){
			if(method.getOperationName().equals(operationName)){
				return method;
			}
		}
		return null;
	}

	public int getSize(){
		return methods.size();
	}

	public String getURL(){
		return url;
	}

	public Object getElementAt(int arg0) {
		return methods.get(arg0);
	}



}
