/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

import java.io.File;
import java.io.IOException;
public class ModelGenerator {
	public static void main(String[] args){
		String xmlFilePath = args[0];


		if(new File(xmlFilePath).exists()){

			String fileName = new File(xmlFilePath).getName();

			int suffixIndex = fileName.indexOf(".");
			fileName = (suffixIndex>0)?(fileName.substring(0,suffixIndex)):fileName;

			String filePath = new File(xmlFilePath).getParent();
			if (filePath == null)
				try {
					filePath = new java.io.File( "." ).getCanonicalPath();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			Translator t = new Translator(xmlFilePath);
			PrismModel pm=t.processXML();

			pm.generateWorkFlowModel(filePath+File.separator+fileName+".pm");
			pm.generatePctlFormulae(filePath+File.separator+fileName+".pctl");

		} else System.out.println("Error: Could not find "+xmlFilePath);
	}
}