/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

public class State {
	static public String EDGESPLIT = " ";
	public String incomingEdges;
	public String outgoingEdges;
	public String id;
	public String type;
	public String name;
	public int n;
	public String toString(){
		return 	"name: "+this.name+" and type: "+this.type+" with ID: "+this.id;
	}
	//------------------------------------------------------------------------------------------
	public State(){
		this.incomingEdges = "";
		this.outgoingEdges = "";
		this.id  = "";
		this.type = "";
		this.name = "";
		int n=-1;
	}
	//------------------------------------------------------------------------------------------
	private String[] parse(String input){
		if(input.isEmpty())
			return new String[0];
	
		if(input.contains(EDGESPLIT))
			return input.split(EDGESPLIT);
		else{
			String[] x= new String[1];
			x[0] = input;
			return x;
		}
	}
	//------------------------------------------------------------------------------------------
	public String[] incomingEdges(){
		return this.parse(incomingEdges);
	}
	//------------------------------------------------------------------------------------------
	public String[] outgoingEdges(){
		return this.parse(this.outgoingEdges);
	}
	//------------------------------------------------------------------------------------------

}
