/*
 *===================================================================================================================
 * 																													
 *	Copyright �2013 [see full license agreement, license.txt]
 *	Radu Calinescu, Kenneth Johnson and Yasmin Rafiq, 
 *  {radu.calinescu, kenneth.johnson, yr534}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the COVE tool suite for the development of self-adaptive service based systems. 
 *					
 *		The COVE tool suite is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


public class Translator {
	static final String INIT_STATE = "InitialNode1";//identify the initial node of the workflow
	static final String GENERATE_FAIL_STATE = "uml:OpaqueAction";
	static final String FAIL_STATE = "FAIL_STATE";
	static final String FAIL = "Fail";
	private Document doc;
	
	//---------------------------------------------------------------------------------
	public Translator(String fileName){
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		try {			
			DocumentBuilder db = dbf.newDocumentBuilder();			
			this.doc = db.parse(new File(fileName));
		}catch(ParserConfigurationException pce) {
			pce.printStackTrace();
		}catch(SAXException se) {
			se.printStackTrace();
		}catch(IOException ioe) {
			ioe.printStackTrace();}
	}
	//---------------------------------------------------------------------------------
	private Edge constructEdge(Node aNode){
		Edge e = new Edge();
		NamedNodeMap ats = aNode.getAttributes();
		e.type = ats.getNamedItem("xmi:type").getNodeValue();
		e.id = ats.getNamedItem("xmi:id").getNodeValue();
		e.name = ats.getNamedItem("name").getNodeValue();
		e.source = ats.getNamedItem("source").getNodeValue();
		e.target = ats.getNamedItem("target").getNodeValue();
		e.pTransition="1.0";
		if(e.name!=null)
			if(e.name.contains("(")){
				int lbracket = e.name.indexOf("(");
				int rbracket = e.name.indexOf(")");
				String probability = e.name.substring(lbracket+1, rbracket);
				e.pTransition =probability;			
			}
		return e;
	}
	//---------------------------------------------------------------------------------
	private State constructState(Node aNode,int n){
		State s = new State();
		NamedNodeMap ats = aNode.getAttributes();
		s.n=n;
		s.type = ats.getNamedItem("xmi:type").getNodeValue();
		s.id = ats.getNamedItem("xmi:id").getNodeValue();
		s.name = ats.getNamedItem("name").getNodeValue();

		if(ats.getNamedItem("outgoing") == null)
			s.outgoingEdges = ""; else
				s.outgoingEdges = ats.getNamedItem("outgoing").getNodeValue();

		if(ats.getNamedItem("incoming") == null)
			s.incomingEdges = ""; else
				s.incomingEdges = ats.getNamedItem("incoming").getNodeValue();		

		return s;
	}
	//---------------------------------------------------------------------------------
	static public String pctl(String requirement, String node) {

		String pctl = "";
		String[] a = requirement.split(";");
		
		if (!a[1].equals("true")) {
			pctl += "filter(forall,";
		}
		
		pctl += a[0] + "[";
		
		if (node != null) {
			pctl += "!(" + node + ")U";
		}
		else {
			pctl += "F";
		}
		
		pctl += "(" + a[2] + ")]";
		
		if (!a[1].equals("true")) {
			pctl += "," + a[1] +")";
		}
		
		return pctl;
	}
	//---------------------------------------------------------------------------------
	public PrismModel processXML(){
		PrismModel pm = new PrismModel();	
		State failState =null;
		String finalStateID="";

		HashMap<String,String> properties = new HashMap<String,String>();
		NodeList comments = doc.getElementsByTagName("ownedComment");
		for(int i=0;i<comments.getLength();i++){			
			if(comments.item(i).getTextContent().contains(FAIL_STATE))
				finalStateID = comments.item(i).getAttributes().getNamedItem("annotatedElement").getNodeValue();
			else
				//pm.addpctlFormulae(pctl(comments.item(i).getTextContent().trim(),null));
			properties.put(comments.item(i).getTextContent().trim(), comments.item(i).getAttributes().getNamedItem("annotatedElement").getNodeValue());
		}

		//read edges from XML document
		NodeList edges = doc.getElementsByTagName("edge");
		for(int i=0;i<edges.getLength();i++)
			pm.addEdge(constructEdge(edges.item(i)));

		//read states from XML document -- make note of the fail state 
		NodeList states = doc.getElementsByTagName("node");		
		for(int i=0;i<states.getLength();i++){
			State an= constructState(states.item(i),i);
			pm.addState(an);
			if(an.id.contentEquals(finalStateID))
				failState=an;//find the fail state
		}

		ArrayList<State> failStates = new ArrayList<State>();
		int nFail=pm.getStates().size();
		for(State an : pm.getStates()){

			if(an.type.contentEquals(GENERATE_FAIL_STATE)){
				for(String id : an.outgoingEdges()){
					Edge e = pm.getEdge(id);
					e.pTransition=an.name+"_p";
				}

				//create a new failure state for, e.g. "sendAlarm"
				State s1 = new State();
				s1.id = an.id+FAIL;
				s1.name = an.name+FAIL;
				s1.type = an.type+FAIL;
				s1.n=nFail++;

				failStates.add(s1);

				//create a new edge to link the failure state 
				Edge e2 = new Edge();
				e2.id = s1.id+"Edge2";
				e2.source=an.id;

				//e2.target=failState.id;
				e2.target=s1.id;
				e2.pTransition = "(1-"+an.name+"_p)";
				pm.addEdge(e2);//store the edge

				//make link between state and fail state.
				s1.incomingEdges+=" "+e2.id;
				an.outgoingEdges+=" "+e2.id;

				Edge e3 = new Edge();
				e3.id = s1.id+"Edge3";
				e3.source = s1.id;
				e3.target = failState.id;
				e3.pTransition="1.0";				
				pm.addEdge(e3);

				s1.outgoingEdges=e3.id;

				//update the fail state with new incoming edge.
				failState.incomingEdges+=" "+e3.id;
			}


		}


		for(State s : failStates)
			pm.addState(s);

		
		//translate pctl properties.
		for(String p : properties.keySet()){
			String nodeId = properties.get(p);
			State state = pm.states.get(nodeId);
			
			pm.addpctlFormulae(pctl(p, state.name.contains("ActivityFinalNode")?null:'"'+state.name+'"'));
		}
		
		return pm;
	}
};