/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.impl.SchemaReaderImpl;
import org.ow2.easywsdl.schema.util.URILocationResolver;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.xml.sax.InputSource;

public abstract class AbstractWSDLReaderImpl
implements WSDLReader {
    protected static final Logger LOG = Logger.getLogger(AbstractWSDLReaderImpl.class.getName());
    private Map<WSDLReader.FeatureConstants, Object> features = new HashMap<WSDLReader.FeatureConstants, Object>();
    private Map<String, AbsItfDescription> importList = new HashMap<String, AbsItfDescription>();
    private SchemaReader schemaReader = null;
    private final URILocationResolver uriLocationResolver = new URILocationResolver();
    private URI documentBaseURI;

    public AbstractWSDLReaderImpl() throws WSDLException {
        try {
            this.schemaReader = new SchemaReaderImpl();
            this.features.put(WSDLReader.FeatureConstants.VERBOSE, false);
            this.features.put(WSDLReader.FeatureConstants.IMPORT_DOCUMENTS, true);
        }
        catch (SchemaException e) {
            throw new WSDLException(e);
        }
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public void setDocumentBaseURI(URI documentBaseURI) {
        this.documentBaseURI = documentBaseURI;
        if (this.schemaReader != null) {
            this.schemaReader.setDocumentBaseURI(documentBaseURI);
        }
    }

    @Override
    public final void setFeature(WSDLReader.FeatureConstants name, Object value) throws WSDLException {
        this.features.put(name, value);
        LOG.finest("set proterty: " + (Object)((Object)name) + " - value = " + value);
    }

    @Override
    public final Object getFeature(WSDLReader.FeatureConstants name) {
        return this.features.get((Object)name);
    }

    @Override
    public final Map<WSDLReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    @Override
    public final void setFeatures(Map<WSDLReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    public Map<String, AbsItfDescription> getImportList() {
        return this.importList;
    }

    public void setImportList(Map<String, AbsItfDescription> importLists) {
        this.importList = importLists;
    }

    public abstract Description read(InputSource var1, Map<URI, AbsItfDescription> var2, Map<URI, AbsItfSchema> var3, boolean var4) throws WSDLException, MalformedURLException, URISyntaxException;

    protected Description readExternalPart(URI externalURI, URI documentBaseURI, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports, boolean deleteImports) throws WSDLException, MalformedURLException, URISyntaxException {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(this.uriLocationResolver.resolve(documentBaseURI, externalURI).openStream());
            inputSource.setSystemId(this.uriLocationResolver.resolve(documentBaseURI, externalURI).toString());
        }
        catch (IOException e) {
            throw new WSDLException(e);
        }
        return this.read(inputSource, descriptionImports, schemaImports, deleteImports);
    }
}

