/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.binding;

import java.net.URI;
import java.net.URISyntaxException;

public interface BindingProtocol {

    public static enum SOAPMEPConstants {
        ONE_WAY("http://www.w3.org/2006/08/soap/mep/one-way/"),
        REQUEST_RESPONSE("http://www.w3.org/2003/05/soap/mep/request-response"),
        SOAP_RESPONSE("http://www.w3.org/2003/05/soap/mep/soap-response/");

        private final String nameSpace;
        private final URI mepURI;

        public static SOAPMEPConstants valueOf(URI pattern) {
            SOAPMEPConstants result = null;
            if (pattern != null) {
                for (SOAPMEPConstants mep : SOAPMEPConstants.values()) {
                    if (!mep.nameSpace.equals(pattern.toString())) continue;
                    result = mep;
                }
            }
            return result;
        }

        private SOAPMEPConstants(String nameSpace) {
            this.nameSpace = nameSpace;
            try {
                this.mepURI = new URI(nameSpace);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        }

        public URI value() {
            return this.mepURI;
        }

        public boolean equals(URI mep) {
            return this.toString().equals(mep.toString());
        }

        public String toString() {
            return this.nameSpace;
        }
    }
}

