﻿/*******************************************************************************
 * Adds abstract operation to LIST
 * 
 * @param name
 *            name of operation
 * @param params
 *            parameters of the operation
 * @param returnType
 *            the return type of the operation
 */
function addAbstractOpr(name, params, returnType) {
	var absOpUML = convertUmlPresentation(name, params, returnType);
	// if not in the list, ADD it
	var notExist = true;
	$("#lstAbstractOp option").each(function() {
		if ($(this).text() == absOpUML) {
			showError("divErrorNewAbstractOp", "The operation already added!");
			notExist = false;
		}
	});
	// add operation
	if (notExist) {
		absOpUMLVal = absOpUML + "#";
		$('#lstAbstractOp').append(
				new Option(absOpUML, absOpUMLVal, false, true));
		// add the operation into abstract operations array of intelligent proxy
		iProxy.add(new AbstractOperation(absOpUML));
		// trigger the change method,
		$('#lstAbstractOp').trigger("change");
	}
}
/*******************************************************************************
 * convert Given Operation into UML presentation
 * 
 * @param name
 *            name of operation
 * @param params
 *            parameters of the operation
 * @param returnType
 *            the return type of the operation
 * @returns {String} returns the UML presentation of the operation for example:
 *          add(param1:float, param2:float):float
 */
function convertUmlPresentation(name, params, returnType) {
	var absOpUML = name + "(";
	// modify parameters
	if (params.length > 0) {
		var paramsArr = params.split(",");
		for ( var i = 0; i < paramsArr.length; i++) {
			// each parameter
			var par = paramsArr[i].trim().split(" ");
			absOpUML += par[1] + ":" + par[0];
			// if it is not the last parameter then put ", "
			if (i != (paramsArr.length - 1)) {
				absOpUML += ", ";
			}
		}
	}

	absOpUML += ")";
	// add return
	absOpUML += ":" + returnType;

	return absOpUML;
}
/*******************************************************************************
 * For Removing from List both for abstract operations list and WSDL list, calls
 * Confirmation Dialog
 * 
 * @param list
 *            id of list
 */
function removeCallConfirmationDialog(list) {
	if ($("#" + list).children("option").size() > 0) {
		if ($("#" + list + " option:selected").index() != -1) {
			// remove from wsdlList
			$("#dialog-confirm").data("removeFrom", list).dialog("open");
		} else {
			alert("Please select an operation, to be removed");
		}
	} else {
		alert("There is no operation to be removed!");
	}
}
/*******************************************************************************
 * Removes option from the LIST both for abstract operations list and WSDL list
 * 
 * @param listID
 *            id of select list
 */
function removeListOption(listID) {
	// get the selected options value
	var selectionText = $("#" + listID + " option:selected").text();
	var list = document.getElementById(listID);

	// then remove the abstract operation from array of intelligent proxy
	if (listID == "lstAbstractOp") {
		iProxy.remove(selectionText);
		// remove the selected element
		list.remove(list.selectedIndex);
		// select first option as selected
		list.selectedIndex = 0;
		// select the first element
		// $("#" + listID + " option:eq(0)").attr("selected", "selected");
		$("#" + listID).trigger("change");
		// trigger the change method,
	}
	// remove from wsdlList and its operations
	else if (listID == "wsdlList") {
		// check any WSDL operation set to abstract operation
		// if there are some operation of WSDL assigned to some abstract
		if (isConcreteOpAssigned2AbstractOp()) {
			// open confirmation box, if confirmed it will redirect to delete
			// procedure
			$("#dialog-confirm-assignedWSDLOp").dialog("open");
		} else {
			// remove WSDL operations from list
			removeAllFromList("concOpList");
			// remove the selected element
			list.remove(list.selectedIndex);
			// select first option as selected
			list.selectedIndex = 0;
			$("#" + listID).trigger("change");
			// trigger the change method,
		}
	}
}

// CONCRETE SERVICES
/*******************************************************************************
 * Adds WSDL URL to LIST if not exist
 * 
 * @param wsldURL
 *            URL of WSDL
 */
function add2ListWSDL(wsldURL) {
	// if not in the list,
	var notExist = true;
	$("#wsdlList option").each(function() {
		if ($(this).val() == wsldURL) {
			showError("divAddWsdlUrlError", "The web service already added!");
			notExist = false;
		}
	});
	// load WSDL
	if (notExist) {
		addNewWSDL(wsldURL);
	}
}
/*******************************************************************************
 * Connect to WSDL URL by AJAX call , load the service information and
 * operations
 * 
 * @param wsldURL
 *            URL of WSDL
 */
function addNewWSDL(wsldURL) {
	$
			.ajax({
				type : "POST",
				dataType : "json",
				timeout : 18000,
				url : "loadWsdl",
				data : {
					wsldURL : wsldURL
				},
				success : function(data) {
					addNewWSDLOperations(data);
				}, // If there was no response from the server
				error : function(jqXHR, textStatus, errorThrown) {
					if (textStatus == "timeout") {
						showError("divAddWsdlUrlError",
								"Timeout risen<br />Bad URL or slow internet connection can cause timeout!");
					} else if (jqXHR.responseText != '') {
						showError("divAddWsdlUrlError", "Error has risen<br />"
								+ jqXHR.responseText);
					} else {
						showError("divAddWsdlUrlError", "Unknown error. Please check internet connection. "
								+ textStatus + ": " + errorThrown);
						console.log("Something really bad happened "
								+ textStatus);
					}

				},

				// capture the request before it was sent to server
				beforeSend : function(jqXHR, settings) {
					// disable the button until we get the response
					$('#btnAdd_LoadWsdl').button("disable").html(
							"...Loading....");
				},
				// this is called after the response or error functions are
				// finished
				// so that we can take some action
				complete : function(jqXHR, textStatus) {
					// enable the button
					$('#btnAdd_LoadWsdl').html("Add & Load").button({
						disabled : false,
						icons : {
							primary : "ui-icon-transferthick-e-w"
						}
					});
					// $("#divAddWsdlUrl").dialog("close");
					$("#wsdlList").effect("highlight", 2000);
				}
			});
}
/*******************************************************************************
 * Add WS of WSDL element to list, then load its operation to concrete operation
 * list
 * 
 * @param data
 *            data returned from ajax
 */
function addNewWSDLOperations(data) {
//if there is a warning from server side, then print the message on the screen
	if(data.warningSet=="true"){
		showError("divAddWsdlUrlError", data.message);
	}
	
	var wsldURL = data.url;
	var serviceName = data.serviceName;
	// Add service name to the WSDL List
	$("#wsdlList").append(
			"<option value='" + wsldURL + "' title='" + wsldURL
					+ "' selected='selected'>" + serviceName + "</option>");
	// Load concrete Operation into List
	loadWSDLOperations(data);

}
/*******************************************************************************
 * Load exist WSDL on change of select wsdlList
 * 
 * @param wsldURL
 */
function loadWSDL(wsldURL) {
	// Do ajax call
	$.ajax({
		type : "POST",
		dataType : "json",
		timeout : 25000,
		url : "loadWsdl",
		data : {
			wsldURL : wsldURL
		},
		success : function(data) {
			loadWSDLOperations(data);
		}, // If there was no response from the server
		error : function(jqXHR, textStatus, errorThrown) {
			if (textStatus == "timeout") {
				showError("divAddWsdlUrlError",
						"Timeout risen<br />You check the URL is correct!");
			} else if (jqXHR.responseText != '') {
				showError("divAddWsdlUrlError", "Error has risen<br />"
						+ jqXHR.responseText);
			} else {
				showError("divAddWsdlUrlError", "BLA BLA error" + textStatus
						+ ": " + errorThrown);
				console.log("Something really bad happened " + textStatus);
			}

		},

		// capture the request before it was sent to server
		beforeSend : function(jqXHR, settings) {
			$("#divLoading").show();
		},
		// this is called after the response or error functions are finished
		// so that we can take some action
		complete : function(jqXHR, textStatus) {
			$("#divLoading").hide();
		}
	});
}
/*******************************************************************************
 * Load exist WSDL OPERATIONS on change, clear old options, append new data
 * 
 * @param data
 *            data from ajax
 */
function loadWSDLOperations(data) {
	var operations = data.methods;// Concrete Operations
	// first clear the list
	removeAllFromList("concOpList");
	// then add operations to the list
	for ( var i = 0; i < operations.length; i++) {
		// select first element
		if (i == 0) {
			$('#concOpList').append(
					"<option title='"+operations[i]+"' value='" + operations[i]
							+ "' selected='selected'>" + operations[i]
							+ "</option>");

		} else {
			$('#concOpList').append(
					"<option title='"+operations[i]+"' value='" + operations[i] + "'>" + operations[i]
							+ "</option>");
		}
	}
}
/*******************************************************************************
 * remove all option of select
 * 
 * @param listId
 *            select id
 */
function removeAllFromList(listId) {
	var concOpList = document.getElementById(listId);
	var numOfElement = concOpList.length;
	for ( var i = 0; i < numOfElement; i++) {
		concOpList.remove(0);
	}
}
/*******************************************************************************
 * Check any WSDL operation set to abstract operation
 * 
 * @return true if there is at least one ws operation assigned to any abstract
 *         operation
 */
function isConcreteOpAssigned2AbstractOp() {
	var wsName = $("#wsdlList option:selected").text();
	var wsURL = $("#wsdlList option:selected").val();
	// get list of abstract operations
	var abstractOpList = iProxy.abstractOpList;
	// if there is at least one abstract operation
	if (abstractOpList.length > 0) {
		for ( var i = 0; i < abstractOpList.length; i++) {
			// get list of concrete operations
			var concreteWSList = abstractOpList[i].concreteWSList;
			// if there is at least one concrete operation
			if (concreteWSList.length > 0) {
				for ( var j = 0; j < concreteWSList.length; j++) {
					// get concrete WS
					var concreteWS = concreteWSList[j];
					// there is at least one ws operation assigned to abstract
					// operation
					if (concreteWS.url == wsURL && concreteWS.name == wsName) {
						return true;
					}
				}
			}
		}
	}
	return false;
}
/*******************************************************************************
 * Unassing the concrete operation, Delete concrete operations, Delete concrete
 * web service
 */
function deleteAssignedWSDLOperation() {
	var wsList = document.getElementById("wsdlList");
	var wsName = $("#wsdlList option:selected").text();
	var wsURL = $("#wsdlList option:selected").val();

	// get list of abstract operations
	var abstractOpList = iProxy.abstractOpList;
	// if there is at least one abstract operation
	if (abstractOpList.length > 0) {
		for ( var i = 0; i < abstractOpList.length; i++) {
			// get list of concrete operations
			var concreteWSList = abstractOpList[i].concreteWSList;
			// if there is at least one concrete operation
			if (concreteWSList.length > 0) {
				for ( var j = 0; j < concreteWSList.length; j++) {
					// get concrete WS
					var concreteWS = concreteWSList[j];
					// there is at least one ws operation assigned to abstract
					// operation
					if (concreteWS.url == wsURL && concreteWS.name == wsName) {
						// remove the related concrete WS
						concreteWSList.splice(j, 1);
						// since the size dynamically changes, we need to move
						// one step to back
						j--;
					}
				}
			}
		}
	}
	// remove WSDL operations from list
	removeAllFromList("concOpList");
	// remove the selected element
	wsList.remove(wsList.selectedIndex);
	// select first option as selected
	wsList.selectedIndex = 0;
	// select the first element
	// $("#" + listID + " option:eq(0)").attr("selected", "selected");
	$("#wsdlList").trigger("change");
	// update assignment table with selected abstract operation
	var abstractOpUML = $("#lstAbstractOp option:selected").text();
	updateTblAssignedConcreteOp(abstractOpUML);
}
