$(document).ready(function() {
	// Assign concrete operations to an abstract operation
	$("#divAssign").click(function() {
		var valid = validateAssignment();
		if (valid) {
			// get the concrete WS variables
			var url = $("#wsdlList option:selected").val();
			var wsName = $("#wsdlList option:selected").text();
			var opUML = $("#concOpList option:selected").text();
			var concreteWS = new ConcreteWS(url, wsName);
			concreteWS.setOperationWithUML(opUML);
			// get abstract operation name
			var abstractOpUML = $("#lstAbstractOp option:selected").text();

			// Ensure it is first time it assigns otherwise update it. if first
			// time button name is
			// assign, otherwise its name is update
			doAssignment(abstractOpUML, concreteWS, "divAssign");
		}
	});
	// Code Convert Modal
	$("#btnCcAssign").click(function() {
		var concreteWS = new ConcreteWS("", "");
		// if caller is from table, then the concrete ws information will be
		// taken from table, otherwise it will take from select list
		if ($(this).data("source") == "divAssign") {
			// get the concrete WS variables
			var url = $("#wsdlList option:selected").val();
			var wsName = $("#wsdlList option:selected").text();
			var opUML = $("#concOpList option:selected").text();
			concreteWS = new ConcreteWS(url, wsName);
			concreteWS.setOperationWithUML(opUML);
		} else if ($(this).data("source") == "imgEditAssign") {// img edit is
			// the caller
			var selectedRow = $(this).data("selectedRow");
			concreteWS = convertRow2ConcreteWS(selectedRow);
		}
		// get abstract operation name
		var abstractOpUML = $("#lstAbstractOp option:selected").text();
		// get parameter from screen and set them to concrete WS
		setConversionCodes2Parameter(concreteWS);

		// assign concrete WS to abstract operation
		var result = iProxy.assign(abstractOpUML, concreteWS);
		var message = "";
		// if it is first time to be assigned;
		if (result) {
			message = "Concrete operation assigned.";
		}
		// assignment already done, it needs to
		// be updated
		else {
			message = "Changes applied...";
		}
		// show the assigned concrete operation on assignment table.
		updateTblAssignedConcreteOp(abstractOpUML);
		// show message
		showError("divSuccess", message);

		$('#tblAssignedConcreteOp').effect("highlight", {
			color : '#88FF4F'
		}, 500);
		// close dialog
		$(".codeConvertWrap").hide();
	});
	// Unassign the concrete operations from abstract operations
	$("#divUnAssign").click(function() {
		var valid = validateAssignment();
		if (valid) {
			// get the concrete WS variables
			var url = $("#wsdlList option:selected").val();
			var wsName = $("#wsdlList option:selected").text();
			var opUML = $("#concOpList option:selected").text();
			var concreteWS = new ConcreteWS(url, wsName);
			concreteWS.setOperationWithUML(opUML);
			// unassing the concreteWs from abstract operation
			unAssingConcreteWS(concreteWS);
		}

	});
	// Hide code convert modal
	$("#btnCcCancel").click(function() {
		$(".codeConvertWrap").hide();
	});
	$("#closeCodeConvertModal").click(function() {
		$(".codeConvertWrap").hide();
	});

	// Assign edit image clicked
	$("#tblAssignedConcreteOp").on("click", ".imgEditAssign", function() {
		var abstractOpUML = $("#lstAbstractOp option:selected").text();
		var selectedRow = $(this).closest('tr');
		// in order to update right row, the row information must be bind to the
		// button
		$("#btnCcAssign").data("selectedRow", selectedRow);
		var concreteWS = convertRow2ConcreteWS(selectedRow);
		doAssignment(abstractOpUML, concreteWS, "imgEditAssign");
	});
	// Assign unassing image clicked
	$("#tblAssignedConcreteOp").on("click", ".imgUnAssign", function() {
		var selectedRow = $(this).closest('tr');
		var concreteWS = convertRow2ConcreteWS(selectedRow);
		unAssingConcreteWS(concreteWS);
	});
});
/*******************************************************************************
 * Checks to see the all required list has a selected option or not
 * 
 * @returns {Boolean}
 */
function validateAssignment() {
	if (isSelected("lstAbstractOp", "divError",
			"Please select an abstract operation.")) {
		if (isSelected("wsdlList", "divError",
				"Please select a concrete web service.")) {
			if (isSelected("concOpList", "divError",
					"Please select a concrete operation.")) {

				return true;
			}
		}
	}
	return false;
}
/*******************************************************************************
 * validates a list element has selected
 * 
 * @param id
 *            id of list
 * @param errorDiv
 *            id of div which will display errors
 * @param message
 *            error message
 * @returns {Boolean} the list has a selected option or not
 */

function isSelected(id, errorDiv, message) {
	// clear the error
	$("#" + errorDiv).hide();
	var selectedOption = $("#" + id + " option:selected");
	// if it is not selected then show error
	if (!selectedOption.text()) {
		$("#" + errorDiv).text(message);
		$("#" + errorDiv).show();
		$("#" + id).effect("highlight", 1000);
		$("#" + errorDiv).effect("highlight", 1000);
		return false;
	}
	return true;
}

/*******************************************************************************
 * checks the concrete web service assigned before or not, if assigned the
 * button name will be 'update'
 * 
 * @param abstractOpUML
 *            uml presentation of abstract operation
 * @param concreteWS
 *            object of Concrete Web service
 * @param source
 *            which element calls this function, assignment div or edit image
 */
function doAssignment(abstractOpUML, concreteWS, source) {
	var absOpIndex = iProxy.getAbsOpIndex(abstractOpUML);
	if (absOpIndex != -1) {
		var concreteIndex = iProxy.abstractOpList[absOpIndex]
				.isAssigned(concreteWS);
		// new element
		if (concreteIndex == -1) {
			// check to see if any other operation of WS already set
			var alreadyAssignedWSIndex = iProxy.abstractOpList[absOpIndex]
					.hasAnyOperationOfConcreteWS(concreteWS);
			// it is new and first element of concreteWS to be set
			if (alreadyAssignedWSIndex == -1) {
				$("#btnCcAssign").button('option', 'label', 'Assign');
				// open code convert modal
				openCodeConvertModal(abstractOpUML, concreteWS);
			}
			// there is another operation of this concrete WS already has been
			// set
			else {
				// confirm that he want to unassign the previous operation and
				// assign this new one
				var operationName = iProxy.abstractOpList[absOpIndex].concreteWSList[alreadyAssignedWSIndex].operation;
				var message = "Only one operation of each concrete web service can be assigned to one abstract operation!\n"
						+ "\""
						+ operationName
						+ "\" operation of "
						+ concreteWS.name
						+ " has ALREADY been ASSIGNED! \n Do you want to REPLACE it with \""
						+ concreteWS.operation + "\"";
				var replaceIt = confirm(message);
				if (replaceIt) {
					// remove previous operation and then allow user assign new
					// one
					iProxy.abstractOpList[absOpIndex]
							.unAssignByIndex(alreadyAssignedWSIndex);
					updateTblAssignedConcreteOp(abstractOpUML);
					openCodeConvertModal(abstractOpUML, concreteWS);
				} else {
					return;
				}

			}

		}// access original concrete WS print its information and then show
		// update button,
		else {
			// it is update, so show original concrete web service details
			$("#btnCcAssign").button('option', 'label', 'Update');
			// open code convert modal
			concreteWS = iProxy.abstractOpList[absOpIndex].concreteWSList[concreteIndex];
			openCodeConvertModal(abstractOpUML, concreteWS);
		}
	}
	// show code convert modal popup
	$(".codeConvertWrap").show();
	$(".codeConvertWrap").draggable({
		containment : "html"
	});
	// binds the information of caller to button.
	$("#btnCcAssign").data("source", source);
}
/*******************************************************************************
 * Pass selected abstract and concrete operations' parameters to be converted
 * and assigned.
 * 
 * @param abstractOpUML
 *            abstract operation UML
 * @param ws
 *            concrete web service
 */
function openCodeConvertModal(abstractOpUML, concreteWS) {
	// convert abstract operation in concrete web service to benefit its
	// operations.
	var tempAbsOp = new ConcreteWS("", "");
	tempAbsOp.setOperationWithUML(abstractOpUML);
	// get abstract operation as an object of Operation
	var abstOp = tempAbsOp.operation;// convert abstract temporary web
	var abstParams = abstOp.params;
	// get the concrete operation
	var concreteOp = concreteWS.operation;
	var concParams = concreteOp.params;

	// service to object of Operation class
	// print code signature of abstract operation
	$("#ccAbstractOperation").text(abstOp.toCodeSig());

	var message = "";
	// print parameters on table
	var isValidParams = putParameterOnModal(concParams, abstParams);
	if (!isValidParams) {
		message = "Warning: Parameter conversion has problem. Please see the following comments!";
	}
	// print concrete operation code signature, not its UML presentation
	// float= foo(float param1, float param2)
	putConcreteOperationOnModal(concreteWS);
	// print return type conversion on table
	var isValidRet = putReturnConvertOnModal(concreteOp.ret, abstOp.ret);
	if (!isValidRet) {
		message = "Warning: Return type conversion has problem, do necessary parsing, if required!. See the comment for details!";
	}
	// parameter and return set correctly then remove the error message
	if (isValidParams && isValidRet) {
		hideError("ccError");
	} else {
		showError("ccError", message);
		// highlight the problem places
		$('.problem').delay(1000).effect("highlight", 2000);
	}

}

/*******************************************************************************
 * unassign a concrete WS from an selected abstract operation and then update
 * its assignment table
 * 
 * @param concreteWS
 *            an onject of ConcreteWS class
 */
function unAssingConcreteWS(concreteWS) {
	// get abstract operation name
	var abstractOpUML = $("#lstAbstractOp option:selected").text();
	var result = iProxy.unAssign(abstractOpUML, concreteWS);
	if (result) {
		// clear the error if operation successful
		hideError("divError");
		// show the assigned concrete operation of WS on the table.
		updateTblAssignedConcreteOp(abstractOpUML);
		$('#tblAssignedConcreteOp').effect("highlight", {
			color : '#E69797'
		}, 500);
		var message = "Successfuly unassigned.";
		showError("divSuccess", message);
	} else {
		var message = "Concrete operation cannot be unassigned. It may already unassigned.";
		showError("divError", message);
	}
}

/*******************************************************************************
 * Update table content with concrete operations assigned to selected abstract
 * operation
 * 
 * @param abstractOp
 *            the selected abstract operation text
 * @returns
 */
function updateTblAssignedConcreteOp(abstractOpUML) {
	// if at least there is one element
	if (abstractOpUML) {
		// if bottom part closed, then open it at first.
		$(".wrapperBottom").slideDown(1000);
		$("#btnGenerate").effect("highlight", "color:red", 1500);
		// set the header of assigned/unassigned table
		$('#spanAssignedAbstractOp').hide().text(abstractOpUML).show("slow");
		var rows = "";
		// get concrete operation of the selected abstract operation, if exist
		var concreteWSList = iProxy.getAbsOp(abstractOpUML).concreteWSList;
		if (concreteWSList.length > 0) {
			$("#divGenerate").show(300);
			var divOperationContainer = "<div class='divContainerOperationTblAssign'>";
			var imgEditAssign = "<img  src='./images/edit.png' height='35' width='28' class='imgEditAssign' title='Edit parameter convertion / return convertion codes.'/>";
			var imgUnAssign = "<img src='./images/unassignSmall.png' height='21' width='50' class='imgUnAssign' title='Unassing selected concrete operation'/>";
			divOperationContainer += imgEditAssign + imgUnAssign + "</div>";

			for ( var i = 0; i < concreteWSList.length; i++) {
				var cssClass = i % 2 == 0 ? "even" : "odd";
				var concreteWS = concreteWSList[i];
				rows += "<tr class='" + cssClass + "'>";
				rows += "<td>" + (i + 1) + "</td>";
				rows += "<td title='" + concreteWS.url + "'>" + concreteWS.name
						+ "</td>";
				rows += "<td>" + concreteWS.operation.uml + "</td>";
				rows += "<td>" + divOperationContainer + "</td>";
				rows += "</tr>";
			}
		} else {
			rows += "<tr class='noElement'><td colspan='4' style='text-align:center;'>Concrete Operations not assigned!</td></tr>";
			$("#divGenerate").slideUp(300);
		}
		// remove previous rows
		$("#tblAssignedConcreteOp > tbody").html("");
		// update table
		$('#tblAssignedConcreteOp > tbody:last').append(rows);
	} else {
		// if there is no element then close the bottom part.
		$(".wrapperBottom").slideUp(1000);
		$("#divGenerate").slideUp(300);
	}

}
/*******************************************************************************
 * converts selected table row into an object of ConcreteWS class
 * 
 * @param selectedRow
 *            selected row of table
 * @returns ConcreteWS an object of concrete web service
 */
function convertRow2ConcreteWS(selectedRow) {
	// get the concrete WS variables
	var url = selectedRow.children('td').eq(1).attr("title");
	var name = selectedRow.children('td').eq(1).text();
	var opUML = selectedRow.children('td').eq(2).text();
	var concreteWS = new ConcreteWS(url, name);
	concreteWS.setOperationWithUML(opUML);
	return concreteWS;
}
/*******************************************************************************
 * TODO gereksiz olabilir. webservice eklersek tabi Present operation signature
 * in code format not in UML format for example: FROM foo(p1:float,
 * p2:float):float TO float foo(float p1, float p2)
 * 
 * @returns code format of operation signature
 */
function uml2CodeSignature(uml) {
	var codeSignature = "";
	var parts = uml.split("):");// to get return part
	codeSignature += parts[1] + " ";// get return part
	var name_Params = parts[0].split("(");
	codeSignature += name_Params[0] + "(";// name of operation
	var params = name_Params[1].split(",");
	var isFirst = true;
	for ( var i = 0; i < params.length; i++) {
		var param = params[i].trim().split(":");
		var name = param[0];
		var type = param[1];
		if (isFirst) {
			codeSignature += type + " " + name;
			isFirst = false;
		} else {
			codeSignature += ", " + type + " " + name;
		}
	}
	codeSignature += ")";
	return codeSignature;
};

/*******************************************************************************
 * Print parameters and convertion on Modal
 * 
 * @param concParams
 *            object of Parameter class for concrete operation
 * @param abstParams
 *            object of Parameter class for abstract operation
 */
function putParameterOnModal(concParams, abstParams) {
	// here we put parameter of conc and abst operations on the screen
	var isValid = true;
	var rows = "";
	for ( var i = 0; i < concParams.length; i++) {
		// check concrete and abstract parameter matchs
		var isMatch = true;
		var comment = "";
		var title = "";
		// concrete parameters type and name
		var concType = concParams[i].type;
		var concName = concParams[i].name;
		var convCode = concParams[i].convCode;

		// concrete parameters type and name
		var abstType = "";
		var abstName = "";
		if (i < abstParams.length) {
			abstType = abstParams[i].type;
			// if any conversion done on the parameters then keep them otherwise
			// put abstract parameters as default
			abstName = abstParams[i].name + ";";

			// their type should match
			if (concType != abstType) {
				// if any code conversion not set, or it only includes the
				// parameter of abstract class, without parsin
				if (!convCode || convCode == abstName) {
					isValid = false;
					isMatch = false;
					title = "Parameter types doesnt match. Manual parsing required.";
					comment = "// " + abstType + " cannot be set to "
							+ concType + ", please do necessary parsing!";
				}
			}
			// if no conversion done then show default, other wise show
			// conversion
			if (convCode) {
				abstName = convCode;
			}
			rows += "<tr title='" + title + "'>";
			rows += "<td class='" + (isMatch ? "ccParamLeft" : "problem")
					+ "'><label id='lblCcParamValue_" + i
					+ "' for='txtCcParamValue_" + i + "'>" + concType + " "
					+ concName + "</label></td>";
			rows += "<td class='" + (isMatch ? "ccEqual" : "problem")
					+ "'>=</td>";
			rows += "<td class='" + (isMatch ? "'" : "problem")
					+ "'><input class='ccParamRight' id='txtCcParamValue_" + i
					+ "'";
			rows += " name = 'txtCcParamValue_" + i
					+ "'  type='text' size='50' value='" + abstName + "'></td>";
			rows += "<td class='ccComment' >" + comment + "</td></tr>";
		}
		// here the number of parameter are not same, but maybe user has
		// provided some conversion code in update senario
		else {
			// if they don't match set css class to problem
			// if any code conversion not set
			if (convCode) {
				rows += "<tr title='" + title + "'>";
				rows += "<td class='" + (isMatch ? "ccParamLeft" : "problem")
						+ "'><label id='lblCcParamValue_" + i
						+ "' for='txtCcParamValue_" + i + "'>" + concType + " "
						+ concName + "</label></td>";
				rows += "<td class='" + (isMatch ? "ccEqual" : "problem")
						+ "'>=</td>";
				rows += "<td class='" + (isMatch ? "'" : "problem")
						+ "'><input class='ccParamRight' id='txtCcParamValue_"
						+ i + "'";
				rows += " name = 'txtCcParamValue_" + i
						+ "'  type='text' size='50' value='" + convCode // the
						// difference
						// is
						// abstName
						// or
						// convCode
						+ "'></td>";
				rows += "<td class='ccComment' >" + comment + "</td></tr>";
			} else {
				isValid = false;
				isMatch = false;
				title = "Number of Parameter doesnt match. Needs a default value";
				comment = "// Set a default value for this concrete operation's parameter.";
				rows += "<tr title='" + title + "'>";
				rows += "<td class='" + (isMatch ? "ccParamLeft" : "problem")
						+ "'><label id='lblCcParamValue_" + i
						+ "' for='txtCcParamValue_" + i + "'>" + concType + " "
						+ concName + "</label></td>";
				rows += "<td class='" + (isMatch ? "ccEqual" : "problem")
						+ "'>=</td>";
				rows += "<td class='" + (isMatch ? "'" : "problem")
						+ "'><input class='ccParamRight' id='txtCcParamValue_"
						+ i + "'";
				rows += " name = 'txtCcParamValue_" + i
						+ "'  type='text' size='50' value='" + abstName // the
						// difference
						// is
						// abstName
						// or
						// convCode
						+ "'></td>";
				rows += "<td class='ccComment' >" + comment + "</td></tr>";
			}
		}

	}
	// remove previous rows
	$("#ccParamTbl > tbody").html("");
	// update table
	$('#ccParamTbl > tbody:last').append(rows);
	return isValid;
}
/*******************************************************************************
 * Concrete operation code signature not UML presentation float tempReturn =
 * foo(float param1, float param2)
 * 
 * @param concreteWS
 */
function putConcreteOperationOnModal(concreteWS) {
	var concreteOp = concreteWS.operation;
	var concParams = concreteOp.params;
	var concRet = concreteOp.ret.type;
	var codeSig = "";
	// if there is no return type
	if (concRet == "void") {
		codeSig = concreteOp.name + "(";
	} else {
		codeSig = concRet + " tempReturn = " + concreteOp.name + "(";
	}
	var isFirst = true;
	for ( var i = 0; i < concParams.length; i++) {
		if (isFirst) {
			codeSig += concParams[i].toCodeSig();
			isFirst = false;
		} else {
			codeSig += ", " + concParams[i].toCodeSig();
		}
	}
	codeSig += ");";
	$("#ccConcreteOperation").text(codeSig);
}

/*******************************************************************************
 * print return type modification on table
 * 
 * @param concReturn
 *            object of Parameter class for concrete operation
 * @param abstReturn
 *            object of Parameter class for abstract operation
 * @returns {Boolean} isValid if return conversion has no problem then returns
 *          true otherwise returns false
 */
function putReturnConvertOnModal(concReturn, abstReturn) {
	// no need for concrete return conversion var convCode =
	// concReturn.convCode;
	// abstract return type and name
	var abstType = abstReturn.type;
	var abstName = abstReturn.name = "actualReturn";
	var isValid = true;

	// if abstract operation is void
	if (abstType == "void") {
		$("#divReturnAbstOp").hide();
		$("#divReturnComment").hide();
	} else {
		// show the return comment and return line, in case of it was invisible
		// from any previous void assignment
		$("#divReturnAbstOp").show();
		$("#divReturnComment").show();
		// concrete return type and name
		var concType = concReturn.type;
		if (concType == "void") {
			var concName = concReturn.name = "??? ;";
		} else {
			concName = concReturn.name = "tempReturn ;";
		}
		var concCode = concReturn.convCode;
		// if no conversion done then show default, other wise show conversion
		if (concReturn.convCode == "") {
			concCode = concName;
		}

		// check concrete and abstract parameter matchs
		var isMatch = true;
		var comment = "";
		var title = "";
		var rows = "";
		// their type should match
		if (concType != abstType) {
			// if any code conversion not set, or it only includes the
			// parameter of abstract class, without parsin
			if (!concCode || concCode == concName) {
				isValid = false;
				isMatch = false;
				title = "Return types doesnt match. Manual parsing required.";
				comment = "// You are trying to set " + concType + " to "
						+ abstType + ", are you sure!";
			}
		}
		rows += "<tr title='" + title + "'>";
		rows += "<td class='" + (isMatch ? "ccParamLeft" : "problem")
				+ "'><label id='lblCcReturnValue' for='txtCcReturnValue'>"
				+ abstType + " " + abstName + "</label></td>";
		rows += "<td class='" + (isMatch ? "ccEqual" : "problem") + "'>=</td>";
		rows += "<td class='" + (isMatch ? "'" : "problem")
				+ "'><input class='ccParamRight' id='txtCcReturnValue'";
		rows += " name = id='txtCcReturnValue' type='text' size='50' value='"
				+ concCode + "'></td>";
		rows += "<td class='ccComment' >" + comment + "</td></tr>";
		// remove previous rows
		$("#ccReturnTbl > tbody").html("");
		// update table
		$('#ccReturnTbl > tbody:last').append(rows);

	}
	return isValid;
}

/*******************************************************************************
 * Take code conversions from modal and set them to concrete web service
 * 
 * @param concreteWS
 */
function setConversionCodes2Parameter(concreteWS) {
	var concParams = concreteWS.operation.params;
	// take each row of parameter table
	for ( var i = 0; i < concParams.length; i++) {
		var type_Name = $("#lblCcParamValue_" + i).text();// get float param1
		var type = type_Name.split(" ")[0];
		var name = type_Name.split(" ")[1];
		var convCode = $("#txtCcParamValue_" + i).val();
		concreteWS.operation.setConvCode2Param(type, name, convCode);
	}
	// set return conversion code
	var retConvCode = $("#txtCcReturnValue").val();// conversion code for
	// return.
	concreteWS.operation.ret.convCode = retConvCode;
}
