﻿$(document).ready(
		function() {
			// intelligentProxy = new IntelligentProxy();
			// Load defaults
			load();
			// Set Dialogs
			dialogPopUps();

			// Set Package Proxy name and close dialog
			$("#setPackageProxyName").click(function() {
				// if text area not empty
				if (setPackageProxyName()) {
					$("#packageProxyName").dialog("close");
					// Show it is updated , from UCDE :)
					$("#divPackageProxy").effect("highlight", 2000);
				}
			});

			// Add new Abstract Operation
			// validate parameter syntax while key press
			$("#txtAbstractOpParameters").keypress(function(event) {
				clearAbstractOpParameters(event);
			});
			$("#txtAbstractOpParameters").focusout(function() {
				// if there are double spaces in a way entered then clear all
				// double spaces
				var text = $("#txtAbstractOpParameters").val().trim();
				text = text.replace(/\s{2,}/g, " ");
				text = text.replace(" ,", ",");
				$("#txtAbstractOpParameters").val(text);
			});
			$("#btnAddAbstractOp").click(
					function() {
						// check abstract operation syntax is valid?
						var isValid = checkAbstractOperationSyntax();
						if (isValid) {
							// Add operation into list
							addAbstractOpr($("#txtAbstractOpName").val(), $(
									"#txtAbstractOpParameters").val(), $(
									"#txtAbstractOpReturn").val());
						}
					});
			// Remove Abstract Operation
			$('#deleteAbstractOperation').click(function() {
				removeCallConfirmationDialog("lstAbstractOp");
			});
			// if abstract operation list element changes, update the assigned
			// table
			$('#lstAbstractOp').change(function() {
				var abstractOpUML = $('#lstAbstractOp option:selected').text();
				updateTblAssignedConcreteOp(abstractOpUML);
			});

			// CONCRETE services
			// Add & Load WSDL URL
			$("#btnAdd_LoadWsdl").click(
					function() {
						// if URL is not empty
						if (validateInput("txtWsdlUrl", "divAddWsdlUrlError",
								"URL cannot be empty!")) {
							// Call Servlet and Load WSDL
							add2ListWSDL($("#txtWsdlUrl").val());
						}
					});
			// Delete WSDL URL
			$("#btnDeleteConcreteUrl").click(function() {
				removeCallConfirmationDialog("wsdlList");
			});

			// if WSDL URL list element changes, load the corresponding
			// operations
			$('#wsdlList').change(function() {
				$("#wsdlList option:selected").each(function() {
					var wsldURL = $(this).val();
					// load exist WSDL
					loadWSDL(wsldURL);
				});
			});

		});
// Load default stuffs
function load() {
	// activate tooltips
	activateToolTips();
	// icon for buttons
	loadButtonIcons();

	// set package and proxy name
	setPackageProxyName();
}
// Activate tool tips for elements
function activateToolTips() {
	// activate tooltips
	$("#divAssignConcrete2Abstract").tooltip();
}
function loadButtonIcons() {
	$("#btnPackageProxyName").button({
		icons : {
			primary : "ui-icon-wrench"
		}
	});
	$("#setPackageProxyName").button({
		icons : {
			primary : "ui-icon-arrowreturn-1-w"
		}
	});
	$("#addAbstractOperation").button({
		icons : {
			primary : "ui-icon-plus"
		}
	});
	$("#deleteAbstractOperation").button({
		icons : {
			primary : "ui-icon-minus"
		}
	});
	$("#btnAddAbstractOp").button({
		icons : {
			primary : "ui-icon-arrowreturn-1-w"
		}
	});
	// Concrete Service Buttons
	$("#btnAddConcreteUrl").button({
		icons : {
			primary : "ui-icon-plus"
		}
	});
	$("#btnDeleteConcreteUrl").button({
		icons : {
			primary : "ui-icon-minus"
		}
	});
	$("#btnAdd_LoadWsdl").button({
		icons : {
			primary : "ui-icon-transferthick-e-w"
		}
	});
	$("#btnCcAssign").button();
	$("#btnCcCancel").button();
	$("#btnGenerate").button({
		icons : {
			primary : "ui-icon-gear"
		}
	});
	$("#downloadIProxy").button();
}
function setPackageProxyName() {
	var isValid = false;
	// if text are not empty
	if (validateInput('packagename', 'errorPackageProxyName',
			'Package name can not be empty')) {
		var packageName = $("#packagename").val().trim();
		if (checkSyntax(packageName)) {
			if (validateInput("iproxyname", "errorPackageProxyName",
					"Proxy name can not be empty")) {
				var iproxyname = $("#iproxyname").val().trim();
				if (checkSyntax(iproxyname)) {
					// then set textbox
					$("#packagename").val(packageName);
					$("#iproxyname").val(iproxyname);
					// set labels
					$("#sPackagename").text(packageName);
					$("#sIproxyname").text(iproxyname);
					isValid = true;
				} else {
					showError("errorPackageProxyName",
							"Proxy name syntax has error");
					isValid = false;
				}
			}
		} else {
			showError("errorPackageProxyName", "Package name syntax has error");
			isValid = false;
		}
	}
	return isValid;
}
function dialogPopUps() {
	// Edit package name and proxy name dialog
	$("#packageProxyName").dialog({
		autoOpen : false,
		title : "Update Package/Proxy name",
		height : 'auto',
		width : 'auto',
		modal : true,
		show : {
			effect : "scale",
			speed : 500
		}
	});
	$("#btnPackageProxyName").click(function() {
		$("#packageProxyName").dialog("open");
	});
	// end

	// Add new Abstract operation dialog
	$("#divNewAbstractOp").dialog({
		autoOpen : false,
		title : "Add Abtract Operation",
		height : 'auto',
		width : 'auto',
		position : [ 650, 150 ],
		modal : true,
		show : {
			effect : "scale",
			speed : 500
		},
		hide : {
			effect : "explode",
			speed : 100
		},
		buttons : [ {
			id : "btnFinishAddAbstractOp",
			text : "Finished",
			click : function() {
				$(this).dialog("close");
			}
		} ]
	});
	$("#addAbstractOperation").click(function() {
		$("#divNewAbstractOp").dialog("open");
	});

	// Confirmation dialog
	$("#dialog-confirm").dialog({
		autoOpen : false,
		resizable : false,
		height : 'auto',
		modal : true,
		buttons : {
			"Yes, Delete It!" : function() {
				$(this).dialog("close");
				removeListOption($(this).data("removeFrom"));
			},
			Cancel : function() {
				$(this).dialog("close");
			}
		}
	});
	// Confirmation for deleting WSDL which its operation already assigned to
	// abstract operations
	$("#dialog-confirm-assignedWSDLOp").dialog({
		autoOpen : false,
		resizable : false,
		height : 'auto',
		width : 'auto',
		modal : true,
		buttons : {
			"Yes, Delete It!" : function() {
				$(this).dialog("close");
				deleteAssignedWSDLOperation();
			},
			Cancel : function() {
				$(this).dialog("close");
			}
		}
	});

	// Concrete Services
	// Add new WSDL url dialog
	$("#divAddWsdlUrl").dialog({
		autoOpen : false,
		title : "Add/Load WSDL",
		height : 'auto',
		width : 'auto',
		position : [ 50, 150 ],
		modal : true,
		show : {
			effect : "scale",
			speed : 500
		},
		hide : {
			effect : "explode",
			speed : 100
		},
		buttons : [ {
			id : "btnFinishAddAbstractOp",
			text : "Finished",
			click : function() {
				$(this).dialog("close");
			}
		} ]
	});
	$("#btnAddConcreteUrl").click(function() {
		$("#divAddWsdlUrl").dialog("open");
	});
	
	$("#reportResult").dialog({
		title : "Couldn't build Intelligent Proxy, Please check details!",
		autoOpen : false,
		resizable : true,
		height : $(window).height(),
		width:'85%',
		modal : true,
		 show: {
		        effect: "blind",
		        duration: 1000
		      },
		      hide: {
		        effect: "explode",
		        duration: 1000
		      },
		buttons : {
			"Close" : function() {
				$(this).dialog("close");
			}
		}
	});
}
// validates if it is not empty, otherwise make errorDiv visible
function validateInput(id, errorDiv, message) {
	var showSpan = $("#" + errorDiv).children("span");
	// not empty
	if ($("#" + id).val().length > 0) {
		showSpan.html("");
		$("#" + errorDiv).hide();
		return true;
	} else {
		showSpan.html(message);
		$("#" + errorDiv).show(300);
		return false;
	}
}

// check Abstract Operation syntax is valid
function checkAbstractOperationSyntax() {
	// Abstract method name can not be empty
	if (validateInput("txtAbstractOpName", "divErrorNewAbstractOp",
			"Abstract Operation Method name can not be empty")) {
		// Abstract method should comply with syntax
		var opName = $("#txtAbstractOpName").val();
		opName = opName.trim();
		// check syntax
		if (checkSyntax(opName)) {
			// set trimmed operation name
			$("#txtAbstractOpName").val(opName);
			// Check return type
			var returnVal = $("#txtAbstractOpReturn").val();
			if (returnVal.length > 0) {
				// if there is a value clean it
				returnVal = returnVal.trim();
				// if there syntax is not valid for return types
				if (checkSyntax(returnVal)) {
					$("#txtAbstractOpReturn").val(returnVal);
					return true;
				} else {
					showError("divErrorNewAbstractOp",
							"Return type has syntax error");
					return false;
				}
			} else {
				returnVal = "void";
				$("#txtAbstractOpReturn").val(returnVal);
				return true;
			}
		} else {
			showError("divErrorNewAbstractOp",
					"Abstract Operation Name has syntax error");
			return false;
		}
	} else
		return false;
}

// dynamic check abstrac operation parameters syntax
function clearAbstractOpParameters(event) {
	var text = $("#txtAbstractOpParameters").val();
	// don't allow two space entered consecutively
	if (event.which == 32) {
		if (text.charAt(text.length - 1) == " ") {
			event.preventDefault();
		}
	}
	// else if char is ","
	else if (event.which == 44) {
		if (text.charAt(text.length - 1) == " ") {
			$("#txtAbstractOpParameters").val(text.trim());
		}
	}
}
// print message on div
function showError(div, message) {
	$("#" + div).children("span").html(message);
	$("#" + div).slideDown("slow");
	$("#" + div).effect("highlight", 1000);
	if(div=="divSuccess"){
		setTimeout("$('#"+div+"').slideUp('slow');", 3000);
	}
}
function hideError(div) {
	$("#" + div).hide(300);
}
function checkSyntax(str) {
	var tempStr = str.match(/^[A-Za-z_][A-Za-z_0-9]*/);
	// if tempStr is same as matched part then return true
	if (tempStr == str) {
		return true;
	} else {
		return false;
	}
}