$(document).ready(function() {

	$("#btnGenerate").click(function() {
		// set package and proxy names
		iProxy.packageName = $("#sPackagename").text();
		iProxy.proxyName = $("#sIproxyname").text();
		generateIntelligentProxy();
	});

});

function generateIntelligentProxy() {
	var jsonIproxy = JSON.stringify(iProxy);
	$.ajax({
		type : "POST",
		dataType : "json",
		timeout : 750000,
		url : "generateProxy",
		data : {
			abstractWS : jsonIproxy
		},
		success : function(data) {
			processReturnedData(data);
		}, // If there was no response from the server
		error : function(jqXHR, textStatus, errorThrown) {
			if (textStatus == "timeout") {
				showError("divError",
						"Timeout risen<br />Please make sure internet is up!");
			} else if (jqXHR.responseText != '') {
				showError("divError", "Error has risen <br />"
						+ jqXHR.responseText);
			} else {
				showError("divError", "Unknown Error, details: <br/>"
						+ textStatus + ": " + errorThrown);
				console.log("Something really bad happened " + textStatus);
			}

		},

		// capture the request before it was sent to server
		beforeSend : function(jqXHR, settings) {
			$("#divLoading").show();
		},
		// this is called after the response or error functions are finished
		// so that we can take some action
		complete : function(jqXHR, textStatus) {
			$("#divLoading").hide();
		}
	});
}

function processReturnedData(data) {
	if (data.link) {
		$("#downloadIProxy").show(300);
		$("#downloadIProxy").button();
		$("#downloadIProxy").click(function() {
			location.href = data.link;
		});
	} else {
		$("#downloadIProxy").hide(300);
		$("#printReport").html(data.message);
		$("#reportResult").dialog("open");
	}
}