/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Yasmin Rafiq, Radu Calinescu and Kenneth Johnson   
 *  {yr534,radu.calinescu,kenneth.johnson}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

package proxygen.business;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.WSDLException;

import proxygen.business.util.Util;
import proxygen.model.webservice.Parameter;
import proxygen.model.webservice.WebService;
import proxygen.model.webservice.WebServiceMethod;

public class EasyWSDLWebService extends WebService {

	private static final long serialVersionUID = 6722051196997923701L;

	public EasyWSDLWebService() {

	}

	public static void main(String[] args) {

		try {
			// URL url = new
			// URL("http://soaptest.parasoft.com/calculator.wsdl");
			URL url = new URL(
					"http://wsf.cdyne.com/WeatherWS/Weather.asmx?WSDL");
			WebService webService = new EasyWSDLWebService();
			webService.load(url);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void load(URL url) throws WSDLException, IOException,
			URISyntaxException, Exception {
		// Set the URL
		this.url = url.toString();
		// TODO methods.clear();
		debug("Reading wsdl");
		String message = "";// holds custom messages
		long time = System.currentTimeMillis();
		// Get whole WSDL
		Description desc = WSDLFactory.newInstance().newWSDLReader().read(url);

		debug("Time to parse wsdl, " + (System.currentTimeMillis() - time)
				+ " milliseconds");
		// TODO: be sure can a WSDL document have more than one service, ask
		// supervisor
		if (desc.getServices().size() > 1) {
			message = "There are more then one service in a single WSDL! Only first service processed.";
			debug(message);
			this.addMessage(message);
		}
		// GET SERVICE NAME
		// if service name not set, warn user and set a default name
		this.serviceName = stubNameFromWsdlUrl(this.url);

		// Also possible service.getQName().getLocalPart();
		debug("Service Name: " + this.serviceName);

		// Get Port types WSDL 1.1 == Interface WSDL2.0 == Class OOP
		for (InterfaceType iface : desc.getInterfaces()) {
			// The name of interface
			String interfaceName = iface.getQName().getLocalPart();
			debug("Parsing " + iface.getOperations().size()
					+ " operations of '" + interfaceName + "' interface");

			// Get each operation which includes information on input,
			// output and fault messages associated with the operation
			for (Operation op : iface.getOperations()) {
				// Get name of Operation
				String operationName = op.getQName().getLocalPart();
				System.out.println("Operation Name= " + operationName);

				// Get inputs(parameters) of operation
				ParameterList params = new ParameterList();
				for (Part paramPart : op.getInput().getParts()) {

					// TODO in some cases param.getElement() becomes null,
					// when the first element is not complex type, in those
					// case it rises an error
					Element element = paramPart.getElement();
					if (element == null) {
						String type = paramPart.getType().getQName()
								.getLocalPart();
						String name = paramPart.getPartQName().getLocalPart();
						params.add(type, name);
						// TODO burada devam etmek yerine bilgi verip return
						// etmek daha uygun olabilir.
						message = "Interface (portType): "
								+ interfaceName
								+ ", Operation (methods):"
								+ operationName
								+ ", the elements are not set properly.<br/> Parent element not set for '"
								+ type + " " + name + "' so '" + type + " "
								+ name + "' used for optimistic choice. ";
						this.addMessage(message);

						System.out
								.println("It looks like the wsdl is not well styled");
						System.out.println("Interface (portType): "
								+ interfaceName + ", Operation (methods):"
								+ operationName
								+ ", the elements are not set properly");
						// return;
					} else {
						// TODO previous one
						// Type type = element.getType();
						// params.add(type.getQName().getLocalPart(),
						// element.getQName().getLocalPart());
						params.addList(parseSimpleTypes(element));
					}
				}

				ParameterList returnType = new ParameterList();
				for (Part returnPart : op.getOutput().getParts()) {
					returnType
							.addList(parseSimpleTypes(returnPart.getElement()));
				}
				String rt = "void";
				if (returnType.size() == 1) {
					rt = returnType.toArray()[0].getType();
				} else if (returnType.size() > 1) {
					// TODO:Looks like code has problem memin

					rt = "Map<String,Object>";
					rt = "String";
				}
				this.methods.add(new WebServiceMethod(url.toString(),
						operationName, params.toArray(), rt));
			}
		}

	}

	private void debug(String string) {
		System.out.println(string);
	}

	private ParameterList parseSimpleTypes(Element e) {
		return parseSimpleTypes(e, "");
	}

	/**
	 * Parse a supplied element to generate a list types and names for a
	 * parameter list
	 * 
	 * @param e
	 *            Element to parse
	 * @param prefix
	 *            prefix to apply
	 */
	private ParameterList parseSimpleTypes(Element e, String prefix) {
		Type t = e.getType();
		ParameterList params = new ParameterList();
		if (t instanceof ComplexType) {
			ComplexType ct = (ComplexType) t;
			if (ct.hasSequence()) {
				for (Element seqE : ct.getSequence().getElements()) {
					params.addList(parseSimpleTypes(seqE, e.getQName()
							.getLocalPart()));
				}
			} else if (ct.hasComplexContent()) {

				// TODO: SUPPORT THESE
				// throw new
				// UnsupportedOperationException("Parsing of complex content is not available in this build");
			} else if (ct.hasSimpleContent()) {
				// throw new
				// UnsupportedOperationException("Parsing of simple content is not available in this build");

			} else if (ct.hasChoice()) {
				// throw new
				// UnsupportedOperationException("Parsing of choice is not available in this build");
			}

		} else {
			// This is a simple element
			String paramType=t.getQName().getLocalPart();
			String paramName = e.getQName().getLocalPart();
			if(paramType.equals("string")){
				paramType="String";
			}
			params.add(paramType, prefix + "_"
					+ paramName);
		}

		return params;
	}

	private class ParameterList {
		private List<Parameter> params;

		public ParameterList() {
			params = new ArrayList<Parameter>();

		}

		public void addList(ParameterList a) {
			params.addAll(a.params);
		}

		public void add(String t, String n) {
			params.add(new Parameter(t, n));
		}

		private Parameter[] toArray() {
			Parameter[] r = new Parameter[params.size()];
			int i = 0;
			for (Parameter s : params) {
				r[i] = s;
				i++;
			}
			return r;

		}

		private int size() {
			return params.size();
		}
	}
	// extract the concrete service names from wsdl URLs
	static private String stubNameFromWsdlUrl(String wsdlUrl) {
		int start = wsdlUrl.lastIndexOf("/") + 1;
		int end = wsdlUrl.lastIndexOf("wsdl") - 1;
		String result = Util.makeUpperFirstLetter(wsdlUrl.substring(start, end));
		return result;
	}
}
