/**
 * 
 */
package proxygen.business;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import proxygen.business.util.Config;
import proxygen.business.util.External;
import proxygen.business.util.Util;
import proxygen.model.json.webservice.AbstractOperation;
import proxygen.model.json.webservice.AbstractWS;
import proxygen.model.json.webservice.ConcreteWS;
import proxygen.model.util.Warning;

/**
 * Created: Jul 8, 2013 9:58:31 PM
 * 
 * @author Mehmet Emin BAKIR
 * 
 */
public class GenerateProxy {

	public Warning start(String sessionID, AbstractWS abstractWS)
			throws Exception {
		Warning warning = new Warning();
		// if there is at least one abstract operation
		if (abstractWS.getAbstractOpList().size() > 0) {
			// Clear, if previously some files created.
			String path = Config.getTempFolder() + "/" + sessionID + "/";
			External.deleteFolder(new File(path));
			// Create WS client classes by each WSDL url.
			String mes = createWSClients(sessionID, abstractWS);
			if (mes != "") {
				mes += "<br />Client of Concrete Web Services are generated.";
				// Generate intelligent proxy
				GenerateProxyFile buildProxy = new GenerateProxyFile();
				buildProxy.generateIntelligentProxy(sessionID, abstractWS);
				// Execute ant to build classes
				mes += External.executeAnt(sessionID);
				Util.debug(mes);
				warning.addMessage(mes);
			} else {
				warning.addMessage("No WSDL found!");
			}
		} else {
			warning.addMessage("No abstract operation created");
		}
		return warning;
	}

	/**
	 * Created: Jul 13, 2013 4:09:11 PM Create WS client classes by each WSDL
	 * url.
	 * 
	 * @param sessionID
	 * @param abstractWS
	 * @return result of executions of each wsdlurl
	 * @throws Exception
	 */
	private String createWSClients(String sessionID, AbstractWS abstractWS)
			throws Exception {
		List<ConcreteWS> uniqueConcreteWSList = getUniqueConcreteWSList(abstractWS);
		String mes = "";
		if (uniqueConcreteWSList.size() > 0) {
			mes = "WSDL Clients are producing <br/>";
			for (ConcreteWS concreteWS : uniqueConcreteWSList) {
				String wsdlURL = concreteWS.getUrl();
				mes += "Starting WSDL URL: " + wsdlURL + " <br/>";
				mes += External.executeWsdl2Java(wsdlURL, sessionID);
				mes += "<br/>Finished WSDL URL: " + wsdlURL + " <br/> <br/>";
			}
		}
		return mes;
	}

	/**
	 * Created: Jul 13, 2013 4:05:04 PM Take unique Concrete WSs, don't take
	 * duplications.
	 * 
	 * @param abstractWS
	 * @return new list of ConcreteWS
	 */
	public List<ConcreteWS> getUniqueConcreteWSList(AbstractWS abstractWS) {
		List<ConcreteWS> uniqueConcreteWSList = new ArrayList<ConcreteWS>();

		for (AbstractOperation abstactOperation : abstractWS
				.getAbstractOpList()) {
			for (ConcreteWS concreteWS : abstactOperation.getConcreteWSList()) {
				int size = uniqueConcreteWSList.size();
				// no matter add first one into list
				if (size == 0) {
					uniqueConcreteWSList.add(concreteWS);
				} else {
					boolean contains = false;
					for (int i = 0; i < size; i++) {
						if (uniqueConcreteWSList.get(i).getName()
								.equals(concreteWS.getName())
								&& uniqueConcreteWSList.get(i).getUrl()
										.equals(concreteWS.getUrl())) {
							contains = true;
							break;
						}
					}
					if (!contains) {
						uniqueConcreteWSList.add(concreteWS);
					}
				}

			}
		}

		return uniqueConcreteWSList;
	}

	/**
	 * Created: Jul 8, 2013 9:58:31 PM
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	/**
	 * Gets link of .jar Created: Jul 16, 2013 1:33:19 AM
	 * 
	 * @param sessionID
	 * @return
	 */
	public String getDownloadLink(String sessionID) {
		String link = "Not found!";
		String jarFolder = Config.getTempFolder() + "/" + sessionID
				+ "/build/lib/";
		File[] files = new File(jarFolder).listFiles();
		if (files != null) {
			for (File file : files) {
				if (file.isFile()) {
					link = "./temp/" + sessionID + "/build/lib/";
					String fileName = file.getName();
					if (fileName.endsWith(".jar")) {
						link += fileName;

						// convert link to JSON format
						link = "{\"link\":\"" + link + "\"}";
					} else
						link = "Not found!";
				}
			}
		}
		return link;
	}

}
