/**
 * 
 */
package proxygen.business;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

import org.ow2.easywsdl.wsdl.api.WSDLException;

import proxygen.model.webservice.WebService;

/**
 * Created: Jun 25, 2013 4:10:13 PM
 * 
 * @author Mehmet Emin BAKIR
 * 
 */
public class LoadWSDL {

	/**
	 * Created: Jun 25, 2013 4:10:13 PM
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		String url = "http://soaptest.parasoft.com/calculator.wsdl";
		LoadWSDL loadW = new LoadWSDL();
		try {
			loadW.load(url);
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (WSDLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * Created: Jun 25, 2013 4:13:42 PM USE EasyWSDLWebService to load web
	 * service signature from the given WSDL url
	 * 
	 * @param url
	 *            URL of WSDL
	 * @throws MalformedURLException 
	 */
	public WebService load(String url) throws WSDLException, IOException, URISyntaxException,Exception {
		WebService webService = new EasyWSDLWebService();
		// Load data
		webService.load(new URL(url));
		//Print service details
		System.out.println(webService);
		return webService;
	}

}
