package proxygen.business.util;

import java.io.InputStream;
import java.util.Properties;

/**
 * This class created for taking environment variables, If in cloud environment,
 * it is not needded then can ben removed.
 * 
 * @author Mehmet Emin BAKIR
 * 
 */
public class Config {
	static private String JAVA_HOME;
	static private String AXIS2_HOME;
	static private String ANT_HOME;
	static private String wsdl2java;
	static private String antBatch;
	
	// path of Web-INF/tempFolder
	static private String tempFolder;

	public static String getJAVA_HOME() {
		return JAVA_HOME;
	}

	private static void setJAVA_HOME(String jAVA_HOME) {
		Config.JAVA_HOME = jAVA_HOME;
	}

	public static String getAXIS2_HOME() {
		return AXIS2_HOME;
	}

	private static void setAXIS2_HOME(String aXIS2_HOME) {
		Config.AXIS2_HOME = aXIS2_HOME;
	}

	public static String getANT_HOME() {
		return ANT_HOME;
	}

	private static void setANT_HOME(String aNT_HOME) {
		Config.ANT_HOME = aNT_HOME;
	}
	/**
	 * Reads path of wsdl2java batch file
	 * @return the wsdl2java
	 */
	public static String getWsdl2java() {
		return wsdl2java;
	}

	/**
	 * @param wsdl2java the wsdl2java to set
	 */
	public static void setWsdl2java(String wsdl2java) {
		Config.wsdl2java = wsdl2java;
	}

	/**
	 * Reads path of ant batch file
	 * @return the antBatch
	 */
	public static String getAntBatch() {
		return antBatch;
	}

	/**
	 * @param antBatch the antBatch to set
	 */
	public static void setAntBatch(String antBatch) {
		Config.antBatch = antBatch;
	}

	/**
	 * @return the webPath
	 */
	public static String getTempFolder() {
		return tempFolder;
	}

	/**
	 * @param webPath
	 *            the webPath to set
	 */
	public static void setTempFolder(String tempFolder) {
		Config.tempFolder = tempFolder;
	}

	public void parseEnvironmentVariables() {
		String envCfgFilePath = "/envVar.properties";
		try {
			InputStream inputStream = this.getClass().getClassLoader()
					.getResourceAsStream(envCfgFilePath);

			Properties properties = new Properties();
			// load the inputStream using the Properties
			properties.load(inputStream);
			// get the value of the property
			String propName = "JAVA_HOME";
			// String
			// defaultVal="'"+propName+"' not read from '"+envCfgFilePath+"' properties file";
			String defaultVal = "";
			setJAVA_HOME(properties.getProperty(propName, defaultVal));
			// print the values
			Util.debug(getJAVA_HOME());

			propName = "AXIS2_HOME";
			defaultVal = "";
			setAXIS2_HOME(properties.getProperty(propName, defaultVal));
			// print the values
			Util.debug(getAXIS2_HOME());

			propName = "ANT_HOME";
			defaultVal = "";
			setANT_HOME(properties.getProperty(propName, defaultVal));
			// print the values
			Util.debug(getANT_HOME());

			propName = "wsdl2java";
			defaultVal="'"+propName+"' not read from '"+envCfgFilePath+"' properties file";
			setWsdl2java(properties.getProperty(propName, defaultVal));
			// print the values
			Util.debug(getWsdl2java());
			
			propName = "antBatch";
			defaultVal="'"+propName+"' not read from '"+envCfgFilePath+"' properties file";
			setAntBatch(properties.getProperty(propName, defaultVal));
			// print the values
			Util.debug(getAntBatch());

		} catch (Exception e) {
			System.err.println("Error: " + e.getMessage());
		}
	}
}
