/**
 * 
 */
package proxygen.business.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;

import proxygen.model.util.Warning;

/**
 * Includes the methods which run external to the tool
 * 
 * @author Mehmet Emin BAKIR
 * 
 */
public class External {
	/**
	 * Delete if file exist, method used to delete existing build.xml file
	 * 
	 * @param args
	 */
	public static void deletefile(String file) {
		File f1 = new File(file);
		if (f1.exists()) {
			boolean success = f1.delete();
			if (!success) {
				Util.error("Deletion failed. " + file);
			} else {
				Util.debug("File deleted. " + file);
			}
		} else {
			Util.error(file + " not found");
		}
	}
	public static void deleteFolder(File folder) {
		
	    File[] files = folder.listFiles();
	    if(files!=null) { //some JVMs return null for empty dirs
	        for(File f: files) {
	            if(f.isDirectory()) {
	                deleteFolder(f);
	            } else {
	                f.delete();
	            }
	        }
	    }
	    folder.delete();
	}
	/***
	 * Executes wsdl2java batch file Created: Jul 12, 2013 8:37:49 PM TODO
	 * burada hata olustugu zaman nasil gosterebiliriz onu dusunmek lazim. hata
	 * olustugu zaman printCmdMessages fonks. unu error kismi calisiyorsa kolay
	 * ama baska turlu dusunmek lazim....
	 * 
	 * @param wsdlURL
	 *            url of wsdl
	 * @param sessionID
	 *            session ID of user, will be used for output director
	 * @throws Exception
	 */
	public static String executeWsdl2Java(String wsdlURL, String sessionID)
			throws Exception {
		String[] env = { Config.getJAVA_HOME(), Config.getAXIS2_HOME() };
		// Output file for each user
		String outputDir = Config.getTempFolder() + "/" + sessionID + "/";
		String axis2 = Config.getWsdl2java();//"cmd /c " + 
		String command = axis2 + " -uri " + wsdlURL + " -o " + outputDir;
		String mes = "wsdl2java runs for url: " + wsdlURL;
		Util.debug("command " + command);
		try {
			Runtime rt = Runtime.getRuntime();
			Util.debug(mes);
			// create clients
			Process pr = rt.exec(command,env);
			mes = printCmdMessages(pr, mes);

		} catch (Exception e) {
			Util.debug(e.toString());
			throw e;
		}
		return mes;
	}

	public static String printCmdMessages(Process pr, String cmd)
			throws IOException, InterruptedException {
		BufferedReader input = null;
		BufferedReader error = null;
		String line = "";
		String mes = "";
		// if there is some output then print the output message
		Boolean firstTime = true;

		input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
		while ((line = input.readLine()) != null) {
			if (firstTime) {
				Util.debug("cmd '" + cmd + "' normal outputs");
				firstTime = false;
			}
			mes += line + "<br />";
		}

		error = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
		firstTime = true;
		error = new BufferedReader(new InputStreamReader(pr.getInputStream()));
		while ((line = error.readLine()) != null) {
			if (firstTime) {
				Util.debug("cmd '" + cmd + "' errors");
				firstTime = false;
			}
			mes += line + "<br />";
		}
		int exitVal = pr.waitFor();
		mes += "<br /> Exited with error code " + exitVal;
		return mes;
	}

	/**
	 * Executes ant to build class under user directory Created: Jul 15, 2013
	 * 1:02:18 PM
	 * 
	 * @param sessionID
	 *            for specific user directory
	 * @throws Exception
	 */
	public static String executeAnt(String sessionID) throws Exception {
		String mes = "'Ant' is Running<br />";
		Util.debug(mes);
		try {
			String outputDir = Config.getTempFolder() + "/" + sessionID;
			System.out.println("outputDir "+ outputDir);
			
			// /bin/sh <path to batch file>/yourbatchfile.sh
			
			String[] env = { Config.getJAVA_HOME(), Config.getAXIS2_HOME() };
			Runtime rt = Runtime.getRuntime();
//			String command = "cmd /c cd " + outputDir
//					+ " && /Users/yasminrafiq/ant/bin/ant.sh";
//			
//			String command2 = "Users/yasminrafiq/ant/bin/ant";
			
			File wdir = new File(outputDir);
			Process pr = rt.exec("ant",env, wdir);
			mes = printCmdMessages(pr, "ant");
		}

		
		catch (Exception e) {
			Util.debug(e.getMessage());
			throw e;
		}
		return mes;
	}
}
