/**
 * 
 */
package proxygen.business.util;

import java.io.File;

/**
 * Created: Jul 12, 2013 8:25:17 PM
 * 
 * @author Mehmet Emin BAKIR
 * 
 */
public class Util {

	/**
	 * Created: Jul 12, 2013 8:25:17 PM
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	/***
	 * Splits UML method signature into argument parts for example:
	 * add(a1:float,a2:float):float to [add,a1,float,a2,float,float] Created:
	 * Jul 14, 2013 10:12:46 AM
	 * 
	 * @param methodSignature
	 *            add(a1:float,a2:float):float in UML format
	 * @return [add, a0, float,, a1, float, float] argument list array
	 */
	public static String[] getArgList(String umlMethodSignature) {

		String str = umlMethodSignature;
		String delims = "[(:) ]+";
		String[] tokens = str.split(delims);
		return tokens;
	}

	/***
	 * Converts UML method signature into java method signature
	 * add(a1:float,a2:float):float to float add(float a1, float a2) Created:
	 * Jul 14, 2013 6:16:11 PM
	 * 
	 * @param umlMethodSignature
	 * @return
	 */
	public static String convert2JavaFormat(String umlMethodSignature) {

		String str = umlMethodSignature;
		String delims = "[(:), ]+";
		String[] tokens = str.split(delims);
		String result = tokens[tokens.length - 1] + " " + tokens[0] + "(";
		boolean isFirst = true;
		for (int i = 1; i < tokens.length - 1; i++) {
			if (isFirst) {
				result += tokens[i + 1] + " " + tokens[i];
				isFirst = false;
			} else {
				result += ", " + tokens[i + 1] + " " + tokens[i];
			}
			i++;
		}
		result += ")";
		return result;
	}

	public static void createDirectory(String path) {
		File theDir = new File(path);
		// if the directory does not exist, create it
		if (!theDir.exists()) {
			System.out.println("creating directory: " + path);
			boolean result = theDir.mkdir();
			if (result) {
				System.out.println("DIR created");
			}
		}
	}

	/***
	 * First letter of String is toUpper, if lower Created: Jul 13, 2013 8:33:28
	 * PM
	 * 
	 * @param param
	 * @return return new string.
	 */
	public static String makeUpperFirstLetter(String param) {
		char[] stringArray = param.toCharArray();
		stringArray[0] = Character.toUpperCase(stringArray[0]);
		return new String(stringArray);
	}

	/**
	 * Created: Jul 12, 2013 8:25:50 PM Simply prints out the message
	 * 
	 * @param mes
	 *            the message
	 */
	public static void debug(String mes) {
		System.out.println(mes);
	}

	/**
	 * Created: Jul 13, 2013 6:21:41 PM Print error
	 * 
	 * @param string
	 */
	public static void error(String mes) {
		System.out.println(mes);

	}

}
