/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Yasmin Rafiq, Radu Calinescu and Kenneth Johnson   
 *  {yr534,radu.calinescu,kenneth.johnson}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */


package proxygen.model.webservice;


public final class Parameter{
	private final String type;
	private final String name;
	public Parameter(String type, String name) {

		this.type = type;
		this.name = name;
	}

	public String getType(){
		return type;
	}
	public String getName(){
		return name;
	}
	public String toString(){
		return type + " " + name;
	}

	public boolean equalType(Parameter p){
		return type.equals(p.type);
	}
}