/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Yasmin Rafiq, Radu Calinescu and Kenneth Johnson   
 *  {yr534,radu.calinescu,kenneth.johnson}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

package proxygen.model.webservice;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;

import org.ow2.easywsdl.wsdl.api.WSDLException;

import proxygen.model.util.Warning;

/**
 * Service represents a generic web service
 * 
 * @author james
 * 
 */
public abstract class WebService extends AbstractListModel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5692656211017107851L;
	protected String url;
	protected String serviceName;
	protected String documentation;
	protected final List<WebServiceMethod> methods;

	protected Warning warning;// information if something bad happens

	public WebService() {
		methods = new ArrayList<WebServiceMethod>();
		this.warning = new Warning();
	}

	public abstract void load(URL url) throws WSDLException, IOException,
			URISyntaxException, Exception;

	/**
	 * Retrieve a method from this web service
	 * 
	 * @param i
	 * @return
	 */
	public WebServiceMethod getMethod(int i) {
		if (i < 0 || i >= methods.size()) {
			throw new IllegalArgumentException(
					"index specified is outside of range 0-" + getSize());
		}
		return methods.get(i);
	}

	/**
	 * Retrieve the method associated with this operations name
	 * 
	 * @param operationName
	 * @return
	 */
	public WebServiceMethod getMethod(String operationName) {
		for (WebServiceMethod method : methods) {
			if (method.getOperationName().equals(operationName)) {
				return method;
			}
		}
		return null;
	}

	/**
	 * Adds warning messages Created: Jul 7, 2013 7:00:02 PM
	 * 
	 * @param message
	 *            message
	 */
	public void addMessage(String message) {
		this.warning.addMessage(message);
	}

	public int getSize() {
		return methods.size();
	}

	public String getURL() {
		return url;
	}

	public Object getElementAt(int arg0) {
		return methods.get(arg0);
	}

	public String toJSon() {
		// TODO I am not sure whether documentation is necessary
		String result = "";
		result += "{\"url\":\"" + this.url + "\",\"";
		result += "serviceName\":\"" + this.serviceName + "\",\"";
		result += "warningSet\":\"" + this.warning.isSet() + "\",\"";
		result += "message\":\"" + this.warning.getMessage() + "\",\"";
		result += "documentation\":\"" + this.documentation + "\",\"";
		result += "methods\":[";
		boolean isFirst = true;
		for (WebServiceMethod operation : this.methods) {

			if (isFirst) {
				result += "\"";
				result += operation.toStringUML();
				result += "\"";
				isFirst = false;
			} else {
				result += ",\"";
				result += operation.toStringUML();
				result += "\"";
			}

		}
		result += "]";
		result += "}";
		return result;
	}

	@Override
	public String toString() {
		String result = "";
		result += "url:" + this.url + "\n";
		result += "serviceName:" + this.serviceName + "\n";
		result += "documentation:" + this.documentation + "\n";
		result += "methods:[";
		result += "\n";
		for (WebServiceMethod operation : this.methods) {
			result += "\t";
			result += operation.toStringUML();
			result += "\n";
		}
		result += "]";
		return result;
	}

}
