/*
 *===================================================================================================================
 * 																													
 *	Copyright 2013 [see full license agreement, license.txt]
 *	Yasmin Rafiq, Radu Calinescu and Kenneth Johnson   
 *  {yr534,radu.calinescu,kenneth.johnson}@york.ac.uk> (University of York)
 *===================================================================================================================  
 *
 *	This file is part of the iPASS intelligent proxy-driven adaptive service-based systems framework for the 
 *  development of self-adaptive computing applications. 
 *					
 *		The iPASS intelligent proxy generator (IPGen) is free software: you can redistribute it and/or modify it 				
 *		under the terms of the GNU Affero General Public License as published by the Free Software Foundation,  		
 *		either version 3 of the License, or (at your option) any later version.  																			
 *																																																																														
 *		You should have received a copy of the GNU Affero General Public License along with IPGen. 
 *		If not, see <http://www.gnu.org/licenses/> 						
 * 																													
 *===================================================================================================================
 */

package proxygen.model.webservice;

/**
 * A service method represents an operation that can be performed upon a remote
 * web service
 * 
 * @author james
 * 
 */
public class WebServiceMethod {
	private final String url;
	private final String operationName;
	private final String returnType;
	private final Parameter[] parameters;

	public WebServiceMethod(String url, String operationName,
			Parameter[] params, String returnType) {
		super();
		this.url = url;
		this.operationName = operationName;
		parameters = params;
		this.returnType = returnType;

	}

	/**
	 * return this methods operation name
	 * 
	 * @return
	 */
	public String getOperationName() {
		return operationName;
	}

	/**
	 * get the return type of this method
	 * 
	 * @return
	 */
	public String getReturnType() {
		return returnType;
	}

	/**
	 * Get the paramaters of this method
	 * 
	 * @return
	 */
	public Parameter[] getParameters() {
		return parameters;
	}

	public String getUrl() {
		return url;
	}

	/**
	 * Returns the number of parameters for this method
	 * 
	 * @return
	 */
	public int getParameterCount() {
		return parameters.length;
	}

	/**
	 * get a specific parameter
	 * 
	 * @param i
	 *            index of parameter (0-getParameterCount()-1)
	 * @return the parameter or null on invalid value
	 */
	public Parameter getParameter(int i) {
		if (i < 0 || i >= parameters.length) {
			return null;
		}
		return parameters[i];
	}

	@Override
	public String toString() {
		String ret = returnType + " " + operationName + "(";
		boolean p = false;
		for (Parameter param : parameters) {
			if (p) {
				ret += ", ";
			} else {
				p = true;
			}
			ret += param;
		}
		return ret + ")";
	}

	public String toStringUML() {
		String result = this.operationName + "(";

		boolean isFirst = true;
		for (Parameter param : this.parameters) {
			if (isFirst) {
				result +=  param.getName()+ ":" +param.getType();
				isFirst = false;
			} else {
				result += ", " + param.getName()+ ":" +param.getType();
			}
		}
		// TODO maybe in some cases the return type become void..
		result += ")" + ":" + this.returnType;

		return result;
	}

	public boolean compatible(WebServiceMethod other) {
		if (parameters.length != other.parameters.length) {
			return false;
		}

		for (int i = 0; i < parameters.length; i++) {
			if (!parameters[i].equalType(other.parameters[i])) {
				return false;
			}
		}

		return true;

	}

}
