package proxygen.servlets;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import proxygen.business.GenerateProxy;
import proxygen.business.util.Config;
import proxygen.business.util.Util;
import proxygen.model.json.webservice.AbstractWS;
import proxygen.model.util.Warning;

import com.google.gson.Gson;

/**
 * Servlet implementation class GenerateProxy
 */
public class GenerateProxySrv extends HttpServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public GenerateProxySrv() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		try {
			// sets tempFolder path and load environment properties
			tuneConfigs();
			// Get user session ID
			String sessionID = request.getSession().getId();

			// get Abstract Web Service
			String abstractWSStr = request.getParameter("abstractWS");
			// Set the JSON format to the relevant bean classes
			AbstractWS abstractWS = new Gson().fromJson(abstractWSStr,
					AbstractWS.class);
			GenerateProxy generateProxy = new GenerateProxy();
			Warning warning = generateProxy.start(sessionID, abstractWS);
			response.setContentType("text/plain");
			response.setCharacterEncoding("UTF-8");
			Gson gson = new Gson();
			String returnStr;
			// if result is successful send link
			String link = generateProxy.getDownloadLink(sessionID);
			if (link == "Not found!") {
				returnStr = gson.toJson(warning);
			} else {
				returnStr = link;
			}
			response.getWriter().write(returnStr);
		} catch (Exception ex) {
			handleRuntimeException(ex, response);
		} finally {

		}
	}

	/**
	 * Takes the WEB-INF file path and sets tempFolder path to WEB-INF/temp then
	 * Reads environment variables and sets them to static variables to be
	 * accessed for all instances. Created: Jul 12, 2013 8:17:58PM
	 */
	private void tuneConfigs() {
		// Take the physical path of WEB-INF folder
		String webInfPath = getServletContext().getRealPath("/");
		String tempFolder = webInfPath + "temp";
		Config.setTempFolder(tempFolder);
		Util.debug("Web-Inf Path=" + Config.getTempFolder());
		// set environment variables (JAVA_HOME, AXIS2_HOME...)
		new Config().parseEnvironmentVariables();
	}

	// The to show exceptions on client side
	public static void handleRuntimeException(Exception ex,
			HttpServletResponse response) {
		response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		try {
			response.setContentType("text/plain");
			response.setCharacterEncoding("UTF-8");
			response.getWriter().write(ex.getMessage());
			response.flushBuffer();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}