package proxygen.servlets;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import proxygen.business.LoadWSDL;
import proxygen.model.webservice.WebService;

/**
 * Servlet implementation class LoadWsdlSrv
 */
public class LoadWsdlSrv extends HttpServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public LoadWsdlSrv() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// get URL and send it to the EasyWSDL
		try {
			String url = request.getParameter("wsldURL");
			LoadWSDL loadWsdl = new LoadWSDL();
			WebService webS=loadWsdl.load(url);
			
			response.setContentType("text/plain");
			response.setCharacterEncoding("UTF-8");
			//Send Web Service data in JSON format
			response.getWriter().write(webS.toJSon());
		} catch (Exception ex) {
			handleRuntimeException(ex,response);
		} finally {

		}
	}
//The to show exceptions on client side
	public static void handleRuntimeException(Exception ex,
			HttpServletResponse response) {
		response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		try {
			response.setContentType("text/plain");
			response.setCharacterEncoding("UTF-8");
			response.getWriter().write(ex.getMessage());
			response.flushBuffer();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

}
