//========================================================================
//
// Copyright (C) 2009
// Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
//
//========================================================================
//
// This file is part of the GPAC general-purpose framework for the 
// development of autonomic computing applications.
//
//    GPAC is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as 
//    published by the Free Software Foundation, either version 3 of 
//    the License, or (at your option) any later version.
//
//    GPAC is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.
//
//    You should have received a copy of the GNU Affero General Public 
//    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
//
//========================================================================

using System;
using System.Data;
using System.Configuration;
using System.Xml;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UpdateModel();
        UpdatePeriod();
        UpdateResourceUrls();
        UpdatePolicySet();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string opStr = "Changing system model: ";
        stateLabel.Text = errorLabel.Text = "";
        if (FileUpload1.HasFile)
        {
            try
            {
                PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
                PolicyEngine.policyEngine engine = new PolicyEngine.policyEngine();
                engine.system = GetSystemModel(FileUpload1.FileContent);
                PolicyEngine.ManagedResourceOpResult result = svc.SetResources(new PolicyEngine.policyEngine[] { engine });

                if (result.Code == PolicyEngine.ManagedResourceOpResultCode.Failure)
                {
                    errorLabel.Text = opStr + result.Message;
                }
                else
                {
                    stateLabel.Text = opStr + result.Message;
                }

                UpdateModel();
                UpdatePolicySet();
            }
            catch (Exception ex)
            {
                errorLabel.Text = opStr + ConvertErrorMessage(ex.Message);
            }

        }
        else
        {
            errorLabel.Text = opStr + "No model file specified";
        }
    }

    private PolicyEngine.system GetSystemModel(System.IO.Stream modelStream)
    {
        XmlDocument model = new XmlDocument();
        model.Load(modelStream);

        System.Text.ASCIIEncoding encoding = new System.Text.ASCIIEncoding();
        System.IO.Stream stream = new System.IO.MemoryStream(encoding.GetBytes(
            model.OuterXml.Replace("<system", "<policyEngine><system").Replace("</system>", "</system></policyEngine>")));
        System.Xml.Serialization.XmlSerializer xmlSerializer =
            new System.Xml.Serialization.XmlSerializer(typeof(PolicyEngine.policyEngine));
        PolicyEngine.policyEngine engine = (PolicyEngine.policyEngine)(xmlSerializer.Deserialize(stream));
        return engine.system;
    }

    private void UpdateModel()
    {
        TextBox5.Text = "";
        try
        {
            PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
            PolicyEngine.ManagedResourceRetrieveAllOpResultOfpolicyEngine result =
                    svc.GetResources(new string[] { "system" });
            if (result.ResourceList[0].system != null && result.ResourceList[0].system.name != null)
            {
                TextBox5.Text += result.ResourceList[0].system.name + "\n";
                foreach (PolicyEngine.resource resource in result.ResourceList[0].system.resource)
                {
                    TextBox5.Text += "   " + resource.ID + "\n";
                    foreach (PolicyEngine.property property in resource.property)
                    {
                        TextBox5.Text += "      " + property.ID + "\n";
                    }
                }
            }
            if (TextBox5.Text.Length > 0)
            {
                TextBox5.Text = TextBox5.Text.Substring(0, TextBox5.Text.Length - 1);
            }
        }
        catch (Exception e)
        {
            errorLabel.Text = ConvertErrorMessage(e.Message);
        }
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        string opStr = "Changing policy engine period: ";
        stateLabel.Text = errorLabel.Text = "";
        try
        {
            PolicyEngine.policyEngine engine = new PolicyEngine.policyEngine();
            engine.period = UInt32.Parse(TextBox1.Text);
            PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
            PolicyEngine.ManagedResourceOpResult result = svc.SetResources(new PolicyEngine.policyEngine[] { engine });
            if (result.Code == PolicyEngine.ManagedResourceOpResultCode.Failure)
            {
                errorLabel.Text = opStr + result.Message;
            }
            else
            {
                stateLabel.Text = opStr + result.Message;
            }
            TextBox1.Text = "";
            UpdatePeriod();
        }
        catch (Exception ex)
        {
            errorLabel.Text = opStr + ConvertErrorMessage(ex.Message);
        }
    }

    private void UpdatePeriod()
    {
        try
        {
            PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
            PolicyEngine.ManagedResourceRetrieveAllOpResultOfpolicyEngine result =
                    svc.GetResources(new string[] { "period" });
            ListBox2.Items.Clear();
            ListBox2.Items.Add(new ListItem(result.ResourceList[0].period.ToString() + " seconds"));
        }
        catch (Exception e)
        {
            errorLabel.Text = ConvertErrorMessage(e.Message);
        }
    }

    protected void Button3_Click(object sender, EventArgs e)
    {
        string opStr = "Changing resource URLs: ";
        stateLabel.Text = errorLabel.Text = "";
        try
        {
            PolicyEngine.policyEngine engine = new PolicyEngine.policyEngine();
            engine.resourceUrls = TextBox2.Text.Split(new char[] { ' ' });
            PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
            PolicyEngine.ManagedResourceOpResult result = svc.SetResources(new PolicyEngine.policyEngine[] { engine });
            if (result.Code == PolicyEngine.ManagedResourceOpResultCode.Failure)
            {
                errorLabel.Text = opStr + result.Message;
            }
            else
            {
                stateLabel.Text = opStr + result.Message;
            }
            TextBox2.Text = "";
            UpdateResourceUrls();
        }
        catch (Exception ex)
        {
            errorLabel.Text = opStr + ConvertErrorMessage(ex.Message);
        }
    }

    private void UpdateResourceUrls() {
        try
        {
            PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
            PolicyEngine.ManagedResourceRetrieveAllOpResultOfpolicyEngine result =
                    svc.GetResources(new string[] { "resourceUrls" });
            TextBox4.Text = "";
            foreach (string resourceUrl in result.ResourceList[0].resourceUrls)
            {
                TextBox4.Text += resourceUrl + "\n";
            }
        }
        catch (Exception e)
        {
            errorLabel.Text = ConvertErrorMessage(e.Message);
        }
    }
    
    protected void Button4_Click(object sender, EventArgs e)
    {
        string opStr = "Changing policies: ";
        stateLabel.Text = errorLabel.Text = "";

        if (FileUpload2.HasFile)
        {
            try
            {
                PolicyEngine.policyEngine engine = new PolicyEngine.policyEngine();
                engine.policySet = GetPolicies(FileUpload2.FileContent);

                PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
                PolicyEngine.ManagedResourceOpResult result = svc.SetResources(new PolicyEngine.policyEngine[] { engine });
                if (result.Code == PolicyEngine.ManagedResourceOpResultCode.Failure)
                {
                    errorLabel.Text = opStr + result.Message;
                }
                else
                {
                    stateLabel.Text = opStr + result.Message;
                }
                UpdatePolicySet();
            }
            catch (Exception ex)
            {
                errorLabel.Text = opStr + ConvertErrorMessage(ex.Message);
            }
        }
        else
        {
            errorLabel.Text = opStr + "No policy file specified";
        }
    }

    private PolicyEngine.autonomicComputingPolicy[] GetPolicies(System.IO.Stream policyStream)
    {
        XmlDocument policySet = new XmlDocument();
        policySet.Load(policyStream);

        System.Text.ASCIIEncoding encoding = new System.Text.ASCIIEncoding();
        System.IO.Stream stream = new System.IO.MemoryStream(encoding.GetBytes(
            policySet.OuterXml.Replace("<policySet", "<policyEngine><policySet xmlns=\"http://www.rcc.com/system\"").Replace("</policySet>", "</policySet></policyEngine>")));
        System.Xml.Serialization.XmlSerializer xmlSerializer =
            new System.Xml.Serialization.XmlSerializer(typeof(PolicyEngine.policyEngine));

        PolicyEngine.policyEngine engine = (PolicyEngine.policyEngine)(xmlSerializer.Deserialize(stream));
        return engine.policySet;
    }

    private void UpdatePolicySet()
    {
        try
        {
            PolicyEngine.PolicyEngine svc = new PolicyEngine.PolicyEngine();
            PolicyEngine.ManagedResourceRetrieveAllOpResultOfpolicyEngine result =
                    svc.GetResources(new string[] { "policySet" });
            TextBox3.Text = "";
            foreach (PolicyEngine.autonomicComputingPolicy policy in result.ResourceList[0].policySet)
            {
                string policystr = "[" + policy.scope + "] [" + policy.condition + "] [" + policy.action + "]";
                TextBox3.Text += policystr + "\n";
            }
        }
        catch (Exception e)
        {
            errorLabel.Text = ConvertErrorMessage(e.Message);
        }
    }

    private string ConvertErrorMessage(string s)
    {
        return s.ToLower().Contains("not found") ?
                "Cannot contact policy engine, please specify correct URL in the Web.Config file" : s;
    }
}
