<%@ Application Language="C#" %>

<script runat="server">
    
    //========================================================================
    //
    // Copyright (C) 2009
    // Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
    //
    //========================================================================
    //
    // This file is part of the GPAC general-purpose framework for the 
    // development of autonomic computing applications.
    //
    //    GPAC is free software: you can redistribute it and/or modify
    //    it under the terms of the GNU Affero General Public License as 
    //    published by the Free Software Foundation, either version 3 of 
    //    the License, or (at your option) any later version.
    //
    //    GPAC is distributed in the hope that it will be useful,
    //    but WITHOUT ANY WARRANTY; without even the implied warranty of
    //    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    //    GNU Affero General Public License for more details.
    //
    //    You should have received a copy of the GNU Affero General Public 
    //    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
    //
    //========================================================================
       
    // Logger.
    private static readonly log4net.ILog log = log4net.LogManager.GetLogger(typeof(HttpApplication));
    
    void Application_Start(object sender, EventArgs e) 
    {
        // Code that runs on application startup
        
        // Initialise logger.
        log4net.Config.XmlConfigurator.ConfigureAndWatch(new System.IO.FileInfo(
            System.Configuration.ConfigurationManager.AppSettings["servicePath"] + "\\log4net.Config"));
        
        // Add log entry.
        log.Info("Initialising GPAC");
        
        // Initialise application state.
        PolicyEngineState state = new PolicyEngineState();
        Application["state"] = state;

        // Start a policy engine processor.
        PolicyEngineProcessor processor = new PolicyEngineProcessor();
        Application["processor"] = processor;

        // Start timer.
        Application["timer"] = new System.Threading.Timer(processor.PolicyEngineStep, null, 2000, state.Period * 1000);

        // Maintain list of "high level" resources.
        System.Collections.Generic.Dictionary<string, System.Collections.Generic.List<object>> highLevelResources =
            new System.Collections.Generic.Dictionary<string, System.Collections.Generic.List<object>>();
        Application["highLevelResources"] = highLevelResources;
        foreach (autonomicComputingPolicy policy in state.PolicySet)
        {
            if (policy.action.StartsWith("RESDEF"))
            {
                highLevelResources.Add(policy.action.Substring(7, policy.action.IndexOf(",") - 7), new System.Collections.Generic.List<object>());
            }
        }
        
        // Add log entry.
        log.Info("GPAC initialised successfully");
    }
    
    void Application_End(object sender, EventArgs e) 
    {
    }
        
    void Application_Error(object sender, EventArgs e) 
    { 
    }

    void Session_Start(object sender, EventArgs e) 
    {
    }

    void Session_End(object sender, EventArgs e) 
    {
    }
               
</script>
