//========================================================================
//
// Copyright (C) 2009
//
// Marc de Jonge <marc.dejonge@tno.nl> (TNO)
// Edwin Matthijssen <edwin.matthijssen@tno.nl> (TNO)
// Bas van Schoonhoven <bas.vanschoonhoven@tno.nl> (TNO)
// Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
//
//========================================================================
//
// This file is part of the GPAC general-purpose framework for the
// development of autonomic computing applications.
//
//    GPAC is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    GPAC is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.
//
//    You should have received a copy of the GNU Affero General Public
//    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
//
//========================================================================

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

using log4net;

[WebService(Namespace = "http://www.yupe.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class logManageabilityAdaptor: ManagedResource<log>
{
    private static readonly ILog log = LogManager.GetLogger(typeof(logManageabilityAdaptor));

    protected override object[] GetRawResources()
    {
        log[] logArray = new log[1];
        logArray[0] = new log();
        
        return logArray;
    }
    
    protected override object GetResourceProperty(object rawResource, string property)
    {
        log typedResource = (log)rawResource;
        
        switch (property)
        {
            case "debug":
                throw new Exception("Not possible!");
            default:
                throw new Exception("unknown property (" + property + ")");
        }
    }
    
    protected override ManagedResourceOpResult SetResourceProperties(log resource)
    {
        ManagedResourceOpResult result = new ManagedResourceOpResult();

        log.Debug(resource.debug);
        result.Code = ManagedResourceOpResultCode.Success;
        
        return result;
    }
}
