<%@ Application Language="C#" %>

<script runat="server">

    //========================================================================
    //
    // Copyright (C) 2009
    // Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
    //
    //========================================================================
    //
    // This file is part of the GPAC general-purpose framework for the 
    // development of autonomic computing applications.
    //
    //    GPAC is free software: you can redistribute it and/or modify
    //    it under the terms of the GNU Affero General Public License as 
    //    published by the Free Software Foundation, either version 3 of 
    //    the License, or (at your option) any later version.
    //
    //    GPAC is distributed in the hope that it will be useful,
    //    but WITHOUT ANY WARRANTY; without even the implied warranty of
    //    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    //    GNU Affero General Public License for more details.
    //
    //    You should have received a copy of the GNU Affero General Public 
    //    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
    //
    //========================================================================
    
    void Application_Start(object sender, EventArgs e) 
    {
        // Initial CPU allocation, to be adjusted by the policy engine.
        Application["premiumCpuAllocation"] = 20;   // percentage of application server CPU
        Application["standardCpuAllocation"] = 20;  // percentage of application server CPU

        // Initial request rates, to be updated by the simulator.
        Application["premiumInterArrivalTime"] = 1100; // milliseconds
        Application["standardInterArrivalTime"] = 1100; // milliseconds
        
        // Initial response time, to be updated by the simulator;
        Application["premiumResponseTime"] = 0; // milliseconds
        Application["standardResponseTime"] = 0; // milliseconds

        // Operational model; constant.
        serviceModelElement[] model = new serviceModelElement[920];
        using (System.IO.StreamReader sr = new System.IO.StreamReader(System.Configuration.ConfigurationManager.AppSettings["operationalModelFile"]))
        {
            for (int i = 0; i < 920; i++)
            {
                model[i] = new serviceModelElement();
                string[] s = sr.ReadLine().Split(',');
                model[i].interArrivalTime = Int32.Parse(s[0]);
                model[i].cpuAllocation = Int32.Parse(s[1]);
                model[i].responseTime = Int32.Parse(s[2]);
            }
        }
        Application["operationalModel"] = model;
    }

    void Application_End(object sender, EventArgs e) 
    {
        //  Code that runs on application shutdown

    }
        
    void Application_Error(object sender, EventArgs e) 
    { 
        // Code that runs when an unhandled error occurs

    }

    void Session_Start(object sender, EventArgs e) 
    {
        // Code that runs when a new session is started

    }

    void Session_End(object sender, EventArgs e) 
    {
        // Code that runs when a session ends. 
        // Note: The Session_End event is raised only when the sessionstate mode
        // is set to InProc in the Web.config file. If session mode is set to StateServer 
        // or SQLServer, the event is not raised.

    }
       
</script>
