//========================================================================
//
// Copyright (C) 2009
// Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
//
//========================================================================
//
// This file is part of the GPAC general-purpose framework for the
// development of autonomic computing applications.
//
//    GPAC is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    GPAC is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.
//
//    You should have received a copy of the GNU Affero General Public
//    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
//
//========================================================================

using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Schema;

namespace AdaptorGenerator
{
    class ModelValidator
    {
        private static bool validationResult;

        // Validate XML document against the model.
        public static bool Validate(XmlDocument modelDoc)
        {
            string path =
                System.IO.Path.GetDirectoryName(
                System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase).Substring(6);

            // string path = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location); // alternative 

            modelDoc.Schemas.Add(LoadXmlSchema(path + "\\App_Data\\metamodel\\managedSystem.xsd"));
            validationResult = true;
            modelDoc.Validate(ValidationCallBack);
            return validationResult;
        }

        // Load an XML schema.
        private static XmlSchema LoadXmlSchema(string schemaFile)
        {
            // Open the file and read the schema.
            System.IO.FileStream fileStream = new System.IO.FileStream(schemaFile, FileMode.Open, FileAccess.Read);
            System.Xml.Schema.XmlSchema loadedSchema = XmlSchema.Read(fileStream, null);

            // Close the file.
            fileStream.Close();

            // Done.
            return loadedSchema;
        }

        // Callback function for XML document validation errors.   
        private static void ValidationCallBack(object sender, System.Xml.Schema.ValidationEventArgs args)
        {
            validationResult = false;
        }

    }
}
