//========================================================================
//
// Copyright (C) 2009
// Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
//
//========================================================================
//
// This file is part of the GPAC general-purpose framework for the
// development of autonomic computing applications.
//
//    GPAC is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    GPAC is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.
//
//    You should have received a copy of the GNU Affero General Public
//    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
//
//========================================================================

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://www.yupe.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class diskDriveManageabilityAdaptor: ManagedResource<diskDrive>
{
    protected override object[] GetRawResources()
    {
        diskDrive[] diskDriveArray = new diskDrive[1];

        //
        // Add code to build managed resource array here
        //
        diskDriveArray[0] = new diskDrive();
        diskDriveArray[0].operationalModel = (string)Application["operationalModel"];
        diskDriveArray[0].id = "Disk1";
        diskDriveArray[0].interArrivalTime = (int)Application["interArrivalTimeDisk1"];
        diskDriveArray[0].powerDefinition = "R{\"power\"}=? [ C<=referenceTimeInterval ]";
        diskDriveArray[0].queueLengthDefinition = "R{\"queueLength\"}=? [ C<=referenceTimeInterval ]";
        diskDriveArray[0].switchToSleepProbability = (double)Application["switchToSleepProbabilityDisk1"];
                
        return diskDriveArray;
    }
    
    protected override object GetResourceProperty(object rawResource, string property)
    {
        diskDrive typedResource = (diskDrive)rawResource;
        
        switch (property)
        {
            case "id":
                //
                // Add code to return the value of the id property here
                //
                return typedResource.id;

            case "interArrivalTime":
                //
                // Add code to return the value of the interArrivalTime property here
                //
                return typedResource.interArrivalTime;

            case "switchToSleepProbability":
                //
                // Add code to return the value of the switchToSleepProbability property here
                //
                return typedResource.switchToSleepProbability;

            case "operationalModel":
                //
                // Add code to return the value of the operationalModel property here
                //
                return typedResource.operationalModel;

            case "powerDefinition":
                //
                // Add code to return the value of the powerDefinition property here
                //
                return typedResource.powerDefinition;

            case "queueLengthDefinition":
                //
                // Add code to return the value of the queueLengthDefinition property here
                //
                return typedResource.queueLengthDefinition;

            default:
                throw new Exception("unknown property (" + property + ")");
        }
    }
    
    protected override ManagedResourceOpResult SetResourceProperties(diskDrive resource)
    {
        ManagedResourceOpResult result = new ManagedResourceOpResult();
        
        // Set the value of read-write diskDrive properties
        if (resource.switchToSleepProbability.HasValue)
        {
            //
            // Add code to set the new value for the switchToSleepProbability property here
            //
            Application["switchToSleepProbability" + resource.id] = resource.switchToSleepProbability.Value;
        }
        
        return result;
    }

    [WebMethod]
    public double GetConfig(int state)
    {
        Application["interArrivalTimeDisk1"] = state;
        return (double)Application["switchToSleepProbabilityDisk1"];
    }
}
