//========================================================================
//
// Copyright (C) 2009
//
// Marc de Jonge <marc.dejonge@tno.nl> (TNO)
// Edwin Matthijssen <edwin.matthijssen@tno.nl> (TNO)
// Bas van Schoonhoven <bas.vanschoonhoven@tno.nl> (TNO)
// Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
//
//========================================================================
//
// This file is part of the GPAC general-purpose framework for the
// development of autonomic computing applications.
//
//    GPAC is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    GPAC is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.
//
//    You should have received a copy of the GNU Affero General Public
//    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
//
//========================================================================

using System;
using System.Runtime.InteropServices;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://www.yupe.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class harddiskManageabilityAdaptor : ManagedResource<harddisk>
{
    [DllImport("kernel32", CharSet = CharSet.Auto)]
    static extern int GetDiskFreeSpaceEx(
     string lpDirectoryName,
     out ulong lpFreeBytesAvailable,
     out ulong lpTotalNumberOfBytes,
     out ulong lpTotalNumberOfFreeBytes);

    protected override object[] GetRawResources()
    {
        ulong total, free, available;
        string id = "C:";

        int res = GetDiskFreeSpaceEx(id, out free, out total, out available);

        harddisk hd = new harddisk();
        hd.Id = id;
        hd.FreeSpace = (long)free;
        hd.TotalSpace = (long)total;

        return new harddisk[] { hd };
    }

    protected override object GetResourceProperty(object rawResource, string property)
    {
        harddisk typedResource = (harddisk)rawResource;

        switch (property)
        {
            case "Id":
                return typedResource.Id;
            case "TotalSpace":
                return typedResource.TotalSpace;
            case "FreeSpace":
                return typedResource.FreeSpace;
            default:
                throw new Exception("unknown property (" + property + ")");
        }
    }

    protected override ManagedResourceOpResult SetResourceProperties(harddisk resource)
    {
        ManagedResourceOpResult result = new ManagedResourceOpResult();

        // Set the value of read-write harddisk properties

        return result;
    }
}
