//========================================================================
//
// Copyright (C) 2009
// Radu Calinescu <Radu.Calinescu@comlab.ox.ac.uk> (University of Oxford)
//
//========================================================================
//
// This file is part of the GPAC general-purpose framework for the
// development of autonomic computing applications.
//
//    GPAC is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    GPAC is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.
//
//    You should have received a copy of the GNU Affero General Public
//    License along with GPAC. If not, see <http://www.gnu.org/licenses/>.
//
//========================================================================

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://www.yupe.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class serviceManageabilityAdaptor: ManagedResource<service>
{
    protected override object[] GetRawResources()
    {
        service[] serviceArray = new service[2];
        
        //
        // Add code to build managed resource array here
        //
        serviceArray[0] = new service();
        serviceArray[0].operationalModel = (serviceModelElement[])Application["operationalModel"];
        serviceArray[0].cpuAllocation = (int)Application["premiumCpuAllocation"];
        serviceArray[0].interArrivalTime = (int)Application["premiumInterArrivalTime"];
        serviceArray[0].name = "premium";
        serviceArray[0].priority = 100;
        serviceArray[0].responseTime = (int)Application["premiumResponseTime"];

        serviceArray[1] = new service();
        serviceArray[1].operationalModel = (serviceModelElement[])Application["operationalModel"];
        serviceArray[1].cpuAllocation = (int)Application["standardCpuAllocation"];
        serviceArray[1].interArrivalTime = (int)Application["standardInterArrivalTime"];
        serviceArray[1].name = "standard";
        serviceArray[1].priority = 10;
        serviceArray[1].responseTime = (int)Application["standardResponseTime"];
        
        return serviceArray;
    }
    
    protected override object GetResourceProperty(object rawResource, string property)
    {
        service typedResource = (service)rawResource;
        
        switch (property)
        {
            case "name":
                //
                // Add code to return the value of the name property here
                //
                return typedResource.name;

            case "priority":
                //
                // Add code to return the value of the priority property here
                //
                return typedResource.priority;

            case "cpuAllocation":
                //
                // Add code to return the value of the cpuAllocation property here
                //
                return typedResource.cpuAllocation;

            case "interArrivalTime":
                //
                // Add code to return the value of the interArrivalTime property here
                //
                return typedResource.interArrivalTime;

            case "responseTime":
                //
                // Add code to return the value of the responseTime property here
                //
                return typedResource.responseTime;

            case "operationalModel":
                //
                // Add code to return the value of the operationalModel property here
                //
                return typedResource.operationalModel;

            default:
                throw new Exception("unknown property (" + property + ")");
        }
    }
    
    protected override ManagedResourceOpResult SetResourceProperties(service resource)
    {
        ManagedResourceOpResult result = new ManagedResourceOpResult();
        
        // Set the value of read-write service properties
        if (resource.cpuAllocation.HasValue)
        {
            //
            // Add code to set the new value for the cpuAllocation property here
            //
            Application[resource.name + "CpuAllocation"] = resource.cpuAllocation.Value;
        }
        
        return result;
    }

    //
    // WEB METHODS THAT THE SERVER SIMULATOR USES TO INTERACT WITH THE MANAGEABILITY ADAPTOR
    //

    // This web method is queried by the simulator when it needs to know the latest
    // CPU allocations decided by the autonomic manager.
    [WebMethod]
    public int GetCpuAllocation(string serviceName)
    {
        return (int)Application[serviceName + "CpuAllocation"];
    }

    // This web method is used by the simulator to update the manageability adaptor with
    // current average request response and inter-arrival time.
    [WebMethod]
    public void UpdateState(string serviceName, int responseTime, int interArrivalTime)
    {
        Application[serviceName + "ResponseTime"] = responseTime;
        Application[serviceName + "InterArrivalTime"] = interArrivalTime;
    }
}