package networkcalculus;

import unikl.disco.nc.Curve;

public class CalculusData {
	
	//Flow of Interest
	private String stringFlowOfInterest;
	
	private String stringSourceDevice;
	private String stringDestinationDevice;
	
	//Charny Bound Data
	private double doubleCharnyBoundCurrentUtilisation;
	private double doubleCharnyBoundMaxUtilisation;
	private double doubleCharnyBoundDelay;
	private double doubleCharnyBoundBacklogBounds;
	private String stringCharnyBoundBacklogPerServer;
	
	//Fair Queueing
	private double doubleFairQueueingDelayBound;
	private double doubleFairQueueingBacklogBound;
	
	//TotalFlowAnalysis
	private double doubleTotalFlowAnalysisDelayBound;
	private double doubleTotalFlowAnalysisBacklogBound;
	private String stringTotalFlowAnalysisPerServer;
	
	//SeparatedFlowAnalysis
	private double doubleSeparatedFlowAnalysisDelayBound;
	private double doubleSeparatedFlowAnalysisBacklogBound;
	
	//PMOO Analysis
	private Curve curvePMOOAnalysisServiceCurve;
	private double doublePMOOAnalysisDelayBound;
	private double doublePMOOAnalysisBacklogBound;
	
	//Hold information on the Delay Parameters
	private double doubleDelayRequirement;
	
	private int intMappedVertSource;
	private int intMappedVertDest;
	
	private double doubleMaxDataSize;
	private double doubleMaxDataRate;
	
	public CalculusData() {
		
	}
	
	public void setMaxDataRate(double a) {
		this.doubleMaxDataRate=a;
	}
	
	public double getMaxDataRate() {
		return this.doubleMaxDataRate;
	}
	
	public void setMaxDataSize(double a) {
		this.doubleMaxDataSize=a;
	}
	
	public double getMaxDataSize() {
		return this.doubleMaxDataSize;
	}
	
	public void setMappedVertSource(int a) {
		this.intMappedVertSource=a;
	}
	
	public int getMappedVertSource() {
		return this.intMappedVertSource;
	}
	
	public void setMappedVertDest(int a) {
		this.intMappedVertDest=a;
	}
	
	public int getMappedVertDest() {
		return this.intMappedVertDest;
	}
	
	public void setDelayRequirement(double a) {
		this.doubleDelayRequirement=a;
	}
	
	public double getDelayRequirement() {
		return this.doubleDelayRequirement;
	}
	
	public void setStringSource(String a) {
		this.stringSourceDevice=new String(a);
	}
	
	public String getStringSource() {
		return this.stringSourceDevice;
	}
	
	public void setStringDestination(String a) {
		this.stringDestinationDevice=new String(a);
	}
	
	public String getStringDestination() {
		return this.stringDestinationDevice;
	}
	
	public void setCharnyBoundBacklogBounds(double a) {
		this.doubleCharnyBoundBacklogBounds=a;
	}
	
	public double getCharnyBoundBacklogBounds() {
		return this.doubleCharnyBoundBacklogBounds;
	}
	
	public void setCharnyBoundBacklogPerServer(String a) {
		this.stringCharnyBoundBacklogPerServer=new String(a);
	}
	
	public String getCharnyBoundBacklogPerServer() {
		return this.stringCharnyBoundBacklogPerServer;
	}
	
	public void setPMOOAnalysisServiceCurve(Curve a) {
		this.curvePMOOAnalysisServiceCurve=a;
	}
	
	public Curve getPMOOAnalysisServiceCurve() {
		return this.curvePMOOAnalysisServiceCurve;
	}
	
	public void setPMOOAnalysisDelayBound(Double a) {
		this.doublePMOOAnalysisDelayBound=a;
	}
	
	public double getPMOOAnalysisDelayBound() {
		return this.doublePMOOAnalysisDelayBound;
	}
	
	public void setPMOOAnalysisBacklogBound(Double a) {
		this.doublePMOOAnalysisBacklogBound=a;
	}
	
	public double getPMOOAnalysisBacklogBound() {
		return this.doublePMOOAnalysisBacklogBound;
	}
	
	public void setSeparatedFlowAnalysisDelayBound(double a) {
		this.doubleSeparatedFlowAnalysisDelayBound=a;
	}
	
	public double getSeparatedFlowAnalysisDelayBound() {
		return this.doubleSeparatedFlowAnalysisDelayBound;
	}
	
	public void setSeparatedFlowAnalysisBacklogBound(double a) {
		this.doubleSeparatedFlowAnalysisBacklogBound=a;
	}
	
	public double getSeparatedFlowAnalysisBacklogBound() {
		return this.doubleSeparatedFlowAnalysisBacklogBound;
	}
	
	public void setTotalFlowAnalysisDelayBound(double a) {
		this.doubleTotalFlowAnalysisDelayBound=a;
	}
	
	public double getTotalFlowAnalysisDelayBound() {
		return this.doubleTotalFlowAnalysisDelayBound;
	}
	
	public void setTotalFlowAnalysisBacklogBound(double a) {
		this.doubleTotalFlowAnalysisBacklogBound=a;
	}
	
	public double getTotalFlowAnalysisBacklogBound() {
		return this.doubleTotalFlowAnalysisBacklogBound;
	}
	
	public void setTotalFlowAnalysisPerServer(String a) {
		this.stringTotalFlowAnalysisPerServer=new String(a);
	}
	
	public String getTotalFlowAnalysisPerServer() {
		return this.stringTotalFlowAnalysisPerServer;
	}
	
	public void setCharnyBoundCurrentUtilisation(double a) {
		this.doubleCharnyBoundCurrentUtilisation=a;
	}
	
	public double getCharnyBoundCurrentUtilisation() {
		return this.doubleCharnyBoundCurrentUtilisation;
	}
	
	public void setCharnyBoundMaxUtilisation(double a) {
		this.doubleCharnyBoundMaxUtilisation=a;
	}
	
	public double getCharnyBoundMaxUtilisation() {
		return this.doubleCharnyBoundMaxUtilisation;
	}
	
	public void setCharnyBoundDelay(double a) {
		this.doubleCharnyBoundDelay=a;
	}
	
	public double getCharnyBoundDelay() {
		return this.doubleCharnyBoundDelay;
	}
	
	public void setFairQueueingDelayBound(double a) {
		this.doubleFairQueueingDelayBound=a;
	}
	
	public double getFairQueueingDelayBound() {
		return this.doubleFairQueueingDelayBound;
	}
	
	public void setFairQueueingBacklogBound(double a) {
		this.doubleFairQueueingBacklogBound=a;
	}
	
	public double getFairQueueingBacklogBound() {
		return this.doubleFairQueueingBacklogBound;
	}
	
	public void setFlowofInterest(String a) {
		this.stringFlowOfInterest=new String(a);
	}
	
	public String getFlowofInterest() {
		return this.stringFlowOfInterest;
	}

}
