/*
 * Decompiled with CFR 0.152.
 */
package mandelbrot;

import com.imsl.math.Complex;
import java.awt.Color;
import java.awt.Graphics;
import mandelbrot.SpecialPlace;

public abstract class Engine {
    double pow;
    Complex cjulia;
    Complex zmin;
    double zsize;
    int nIter;
    Color[] colorMap;
    boolean is_sinz;
    boolean is_ez;
    boolean is_zz;
    boolean is_zi;
    int canvasSize;
    Complex[][] z;
    Complex[][] c;
    int[][] n;
    int nColor;

    abstract void initOneZC(int var1, int var2, Complex var3);

    Engine() {
        this.cjulia = SpecialPlace.rec[0].c;
        this.pow = SpecialPlace.rec[0].pow;
        this.zmin = SpecialPlace.rec[0].zmin;
        this.zsize = SpecialPlace.rec[0].zsize;
        this.setNIter(SpecialPlace.rec[0].n_iter);
        this.n = null;
    }

    void setNIter(int n) {
        this.nColor = this.nIter = n;
        this.setColorMap();
    }

    void initN() {
        this.n = new int[this.canvasSize][this.canvasSize];
        for (int i = 0; i < this.canvasSize; ++i) {
            for (int j = 0; j < this.canvasSize; ++j) {
                this.n[i][j] = this.nIter;
            }
        }
    }

    void initZC() {
        this.z = new Complex[this.canvasSize][this.canvasSize];
        this.c = new Complex[this.canvasSize][this.canvasSize];
        double scale = this.zsize / (double)this.canvasSize;
        for (int i = 0; i < this.canvasSize; ++i) {
            for (int j = 0; j < this.canvasSize; ++j) {
                this.initOneZC(i, j, new Complex(i, j).times(scale).plus(this.zmin));
            }
        }
    }

    void setColorMap() {
        Color c1 = Color.yellow;
        Color c2 = Color.blue;
        this.colorMap = new Color[this.nColor];
        for (int i = 0; i < this.nColor; ++i) {
            float ratio = (float)Math.sqrt(Math.sqrt((double)i / (double)this.nColor));
            this.colorMap[i] = new Color((int)((double)((float)c1.getRed() * ratio) + (double)c2.getRed() * (1.0 - (double)ratio)), (int)((double)((float)c1.getGreen() * ratio) + (double)c2.getGreen() * (1.0 - (double)ratio)), (int)((double)((float)c1.getBlue() * ratio) + (double)c2.getBlue() * (1.0 - (double)ratio)));
        }
    }

    public void setEqn(boolean sinz, boolean ez, boolean zz, boolean zi) {
        this.is_sinz = sinz;
        this.is_ez = ez;
        this.is_zz = zz;
        this.is_zi = zi;
    }

    Complex oneIter(Complex z, Complex c) throws ArithmeticException {
        Complex z1 = this.is_sinz ? Complex.sin(z) : new Complex(0.0);
        if (this.is_ez) {
            z1 = z1.plus(Complex.exp(z));
        }
        if (this.is_zz) {
            z1 = z1.plus(Complex.pow(z, z));
        }
        if (this.is_zi) {
            z1 = z1.plus(Complex.pow(z, this.pow));
        }
        return z1.plus(c);
    }

    boolean is_diverged(int i, int j) {
        return Complex.abs(this.z[i][j]) > (double)(this.is_zi ? 2 : 5);
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.canvasSize, this.canvasSize);
        for (int nij = 0; nij < this.nIter; ++nij) {
            this.iterateCanvas(nij);
            g.setColor(this.colorMap[nij]);
            for (int i = 0; i < this.canvasSize; ++i) {
                for (int j = 0; j < this.canvasSize; ++j) {
                    if (this.n[i][j] != nij) continue;
                    g.fillRect(i, this.canvasSize - (j + 1), 1, 1);
                }
            }
        }
    }

    void iterateCanvas(int nij) {
        for (int i = 0; i < this.canvasSize; ++i) {
            for (int j = 0; j < this.canvasSize; ++j) {
                if (this.z[i][j] == null) continue;
                this.z[i][j] = this.oneIter(this.z[i][j], this.c[i][j]);
                if (!this.is_diverged(i, j)) continue;
                this.z[i][j] = null;
                this.n[i][j] = nij;
            }
        }
    }
}

