/*
 * Decompiled with CFR 0.152.
 */
package mandelbrot;

import com.imsl.math.Complex;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import mandelbrot.QuarterCanvas;
import mandelbrot.SpecialPlace;
import ss.awt.Box;
import ss.awt.TextUtils;
import ss.math.ComplexUtils;

public class Mandel
extends Applet {
    boolean isStandalone = false;
    QuarterCanvas canvas1 = new QuarterCanvas();
    Box panel_eqn = new Box();
    Box panel_c = new Box();
    Box panel_size = new Box();
    CheckboxGroup checkboxGroup_choice = new CheckboxGroup();
    Panel panel_redrawmj = new Panel();
    Panel panel_morj = new Panel();
    Checkbox checkbox_julia = new Checkbox();
    GridLayout gridLayout1 = new GridLayout();
    Checkbox checkbox_mand = new Checkbox();
    Panel panel_redraw = new Panel();
    Button button_redrawm = new Button();
    Panel panel_graph = new Panel();
    Button button_reset = new Button();
    GridLayout gridLayout6 = new GridLayout();
    Panel panel_nz = new Panel();
    FlowLayout flowLayout5 = new FlowLayout();
    Panel panel_niter = new Panel();
    TextField textField_n = new TextField();
    Label label_n = new Label();
    FlowLayout flowLayout8 = new FlowLayout();
    Panel panel_zoom = new Panel();
    TextField textField_zoom = new TextField();
    Label label_zoom = new Label();
    GridLayout gridLayout7 = new GridLayout();
    GridBagLayout gridBagLayout_top = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    Panel panel_special = new Panel();
    Choice choice_special = new Choice();
    Label label_special = new Label();
    Panel panel_param = new Panel();
    TextField textField_w = new TextField();
    Panel panel_w = new Panel();
    Label label_re_z = new Label();
    Label label_im_z = new Label();
    FlowLayout flowLayout9 = new FlowLayout();
    FlowLayout flowLayout7 = new FlowLayout();
    Panel panel_re_z = new Panel();
    FlowLayout flowLayout6 = new FlowLayout();
    FlowLayout flowLayout3 = new FlowLayout();
    Panel panel_im_z = new Panel();
    FlowLayout flowLayout2 = new FlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    Panel panel_label_imz = new Panel();
    FlowLayout flowLayout14 = new FlowLayout();
    FlowLayout flowLayout12 = new FlowLayout();
    FlowLayout flowLayout10 = new FlowLayout();
    Panel panel_label_rez = new Panel();
    Panel panel_width = new Panel();
    TextField textField_re_z = new TextField();
    Panel panel_maxx = new Panel();
    Label label_w = new Label();
    Panel panel_centre = new Panel();
    TextField textField_im_z = new TextField();
    Label label_rec = new Label();
    TextField textField_imc = new TextField();
    FlowLayout flowLayout13 = new FlowLayout();
    Label label_imc = new Label();
    TextField textField_rec = new TextField();
    Checkbox checkbox_sinz = new Checkbox();
    Panel panel_eqnlabel = new Panel();
    Label label_k = new Label();
    TextField textField_k = new TextField();
    FlowLayout flowLayout4 = new FlowLayout();
    Checkbox checkbox_ez = new Checkbox();
    Checkbox checkbox_zz = new Checkbox();
    Panel panel_comp = new Panel();
    Label label_eqn = new Label();
    GridLayout gridLayout2 = new GridLayout();
    FlowLayout flowLayout11 = new FlowLayout();
    Checkbox checkbox_zk = new Checkbox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout_top);
        this.panel_redrawmj.setLayout(this.gridBagLayout3);
        this.panel_morj.setLayout(this.gridLayout1);
        this.checkbox_julia.setCheckboxGroup(this.checkboxGroup_choice);
        this.checkbox_julia.setLabel("Julia");
        this.checkbox_julia.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.checkbox_julia_itemStateChanged(e);
            }
        });
        this.gridLayout1.setRows(2);
        this.gridLayout1.setColumns(1);
        this.checkbox_mand.setCheckboxGroup(this.checkboxGroup_choice);
        this.checkbox_mand.setLabel("Mandelbrot");
        this.checkbox_mand.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.checkbox_mand_itemStateChanged(e);
            }
        });
        this.checkboxGroup_choice.setSelectedCheckbox(this.checkbox_mand);
        this.button_redrawm.setActionCommand("Redraw");
        this.button_redrawm.setLabel("Redraw with settings");
        this.button_redrawm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mandel.this.button_redrawm_actionPerformed(e);
            }
        });
        this.button_reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mandel.this.button_reset_actionPerformed(e);
            }
        });
        this.button_reset.setLabel("Reset to special place");
        this.button_reset.setActionCommand("Redraw");
        this.panel_redraw.setLayout(this.gridLayout6);
        this.gridLayout6.setRows(2);
        this.gridLayout6.setColumns(1);
        this.gridLayout6.setVgap(5);
        this.panel_niter.setLayout(this.flowLayout5);
        this.label_n.setText("iter =");
        this.panel_zoom.setLayout(this.flowLayout8);
        this.label_zoom.setText("zoom =");
        this.panel_nz.setLayout(this.gridLayout7);
        this.gridLayout7.setRows(2);
        this.gridLayout7.setColumns(1);
        this.flowLayout8.setAlignment(0);
        this.flowLayout5.setAlignment(0);
        this.canvas1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Mandel.this.canvas1_mouseReleased(e);
            }
        });
        this.label_special.setText("special places");
        this.choice_special.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.choice_special_itemStateChanged(e);
            }
        });
        this.panel_w.setLayout(this.flowLayout12);
        this.label_re_z.setText("Re.z =");
        this.label_im_z.setText(" Im.z =");
        this.flowLayout9.setVgap(0);
        this.flowLayout9.setHgap(0);
        this.flowLayout9.setAlignment(0);
        this.flowLayout7.setVgap(0);
        this.flowLayout7.setHgap(0);
        this.flowLayout7.setAlignment(0);
        this.panel_size.setLayout(this.flowLayout14);
        this.panel_re_z.setLayout(this.flowLayout1);
        this.flowLayout6.setAlignment(0);
        this.flowLayout3.setVgap(0);
        this.flowLayout3.setHgap(0);
        this.flowLayout3.setAlignment(0);
        this.panel_im_z.setLayout(this.flowLayout2);
        this.flowLayout2.setVgap(0);
        this.flowLayout2.setHgap(0);
        this.flowLayout2.setAlignment(0);
        this.flowLayout1.setVgap(0);
        this.flowLayout1.setHgap(0);
        this.panel_label_imz.setLayout(this.flowLayout9);
        this.flowLayout14.setAlignment(0);
        this.flowLayout14.setHgap(0);
        this.flowLayout14.setVgap(0);
        this.flowLayout12.setVgap(0);
        this.flowLayout12.setHgap(0);
        this.flowLayout12.setAlignment(0);
        this.flowLayout10.setVgap(0);
        this.flowLayout10.setAlignment(0);
        this.panel_label_rez.setLayout(this.flowLayout3);
        this.panel_width.setLayout(this.flowLayout10);
        this.panel_maxx.setLayout(this.flowLayout7);
        this.label_w.setText("w = ");
        this.panel_centre.setLayout(this.flowLayout6);
        this.label_rec.setText("Re.c =");
        this.panel_c.setLayout(this.flowLayout13);
        this.flowLayout13.setAlignment(0);
        this.label_imc.setText("Im.c =");
        this.checkbox_sinz.setLabel("sin(z)");
        this.checkbox_sinz.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.checkbox_sinz_itemStateChanged(e);
            }
        });
        this.panel_eqnlabel.setLayout(this.flowLayout4);
        this.label_k.setText(";  k =");
        this.flowLayout4.setAlignment(0);
        this.checkbox_ez.setLabel("e^z");
        this.checkbox_ez.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.checkbox_ez_itemStateChanged(e);
            }
        });
        this.checkbox_zz.setLabel("z^z");
        this.checkbox_zz.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.checkbox_zz_itemStateChanged(e);
            }
        });
        this.panel_comp.setLayout(this.flowLayout11);
        this.label_eqn.setText("sin(z) + e^z + z^z + z^k + c");
        this.gridLayout2.setRows(2);
        this.flowLayout11.setAlignment(0);
        this.panel_eqn.setLayout(this.gridLayout2);
        this.checkbox_zk.setLabel("z^k");
        this.checkbox_zk.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Mandel.this.checkbox_zk_itemStateChanged(e);
            }
        });
        this.panel_param.setLayout(this.gridBagLayout1);
        this.panel_graph.add((Component)this.canvas1, null);
        this.panel_redrawmj.add((Component)this.panel_morj, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel_morj.add((Component)this.checkbox_mand, null);
        this.panel_morj.add((Component)this.checkbox_julia, null);
        this.panel_redrawmj.add((Component)this.panel_nz, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel_zoom.add((Component)this.label_zoom, null);
        this.panel_zoom.add((Component)this.textField_zoom, null);
        this.panel_nz.add((Component)this.panel_zoom, null);
        this.panel_nz.add((Component)this.panel_niter, null);
        this.panel_niter.add((Component)this.label_n, null);
        this.panel_niter.add((Component)this.textField_n, null);
        this.panel_redrawmj.add((Component)this.panel_redraw, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 1, 0), 0, 0));
        this.panel_redraw.add((Component)this.button_redrawm, null);
        this.panel_redraw.add((Component)this.button_reset, null);
        this.add((Component)this.panel_graph, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panel_redrawmj, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panel_special, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel_special.add((Component)this.label_special, null);
        this.panel_special.add((Component)this.choice_special, null);
        for (int i = 0; i < SpecialPlace.n_special(); ++i) {
            this.choice_special.addItem(SpecialPlace.rec[i].name);
        }
        this.add((Component)this.panel_param, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel_c.add((Component)this.label_rec, null);
        this.panel_c.add((Component)this.textField_rec, null);
        this.panel_c.add((Component)this.label_imc, null);
        this.panel_c.add((Component)this.textField_imc, null);
        this.panel_eqn.add((Component)this.panel_eqnlabel, null);
        this.panel_eqnlabel.add((Component)this.label_eqn, null);
        this.panel_eqn.add((Component)this.panel_comp, null);
        this.panel_comp.add((Component)this.checkbox_sinz, null);
        this.panel_comp.add((Component)this.checkbox_ez, null);
        this.panel_comp.add((Component)this.checkbox_zz, null);
        this.panel_comp.add((Component)this.checkbox_zk, null);
        this.panel_comp.add((Component)this.label_k, null);
        this.panel_comp.add((Component)this.textField_k, null);
        this.panel_param.add((Component)this.panel_eqn, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.panel_param.add((Component)this.panel_c, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.panel_param.add((Component)this.panel_size, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.panel_centre.add((Component)this.panel_label_rez, null);
        this.panel_label_rez.add((Component)this.label_re_z, null);
        this.panel_centre.add((Component)this.panel_re_z, null);
        this.panel_re_z.add((Component)this.textField_re_z, null);
        this.panel_centre.add((Component)this.panel_label_imz, null);
        this.panel_label_imz.add((Component)this.label_im_z, null);
        this.panel_centre.add((Component)this.panel_im_z, null);
        this.panel_im_z.add((Component)this.textField_im_z, null);
        this.panel_size.add((Component)this.panel_centre, null);
        this.panel_size.add((Component)this.panel_width, null);
        this.panel_width.add((Component)this.panel_w, null);
        this.panel_w.add((Component)this.label_w, null);
        this.panel_width.add((Component)this.panel_maxx, null);
        this.panel_maxx.add((Component)this.textField_w, null);
        this.panel_size.setTitle("graph centre and width");
        this.panel_c.setTitle("Julia c value");
        this.panel_eqn.setTitle("iterated equation");
    }

    public void start() {
        this.set_special(0);
        this.setZ();
        this.canvas1.setEqn(this.checkbox_sinz.getState(), this.checkbox_ez.getState(), this.checkbox_zz.getState(), this.checkbox_zk.getState());
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    void redraw_canvas() {
        this.canvas1.setEqn(this.checkbox_sinz.getState(), this.checkbox_ez.getState(), this.checkbox_zz.getState(), this.checkbox_zk.getState());
        if (this.checkbox_mand.getState()) {
            this.canvas1.redrawM(TextUtils.getTextFieldAsInt(this.textField_n, 1, SpecialPlace.rec[0].n_iter), this.get_zmin(), this.get_zsize(), TextUtils.getTextFieldAsDouble(this.textField_k, SpecialPlace.rec[0].pow));
        } else {
            this.canvas1.redrawJ(TextUtils.getTextFieldAsInt(this.textField_n, 1, SpecialPlace.rec[0].n_iter), this.get_zmin(), this.get_zsize(), TextUtils.getTextFieldAsComplex(this.textField_rec, this.textField_imc, SpecialPlace.rec[0].c), TextUtils.getTextFieldAsDouble(this.textField_k, SpecialPlace.rec[0].pow));
        }
    }

    void button_redrawm_actionPerformed(ActionEvent e) {
        if (this.noCheckBoxSet()) {
            this.checkbox_zk.setState(true);
            this.setPowerIF();
            this.setEqnText();
        }
        this.redraw_canvas();
    }

    private Complex get_zmin() {
        Complex zmin = SpecialPlace.rec[0].zmin;
        double zsize = SpecialPlace.rec[0].zsize;
        double w = TextUtils.getTextFieldAsDouble(this.textField_w, zsize);
        Complex z = TextUtils.getTextFieldAsComplex(this.textField_re_z, this.textField_im_z, ComplexUtils.Offset(zmin, 0.5 * zsize));
        z = ComplexUtils.Offset(z, -0.5 * w);
        return z;
    }

    private double get_zsize() {
        return TextUtils.getTextFieldAsDouble(this.textField_w, SpecialPlace.rec[0].zsize);
    }

    void checkbox_sinz_itemStateChanged(ItemEvent e) {
        this.setEqnText();
    }

    void checkbox_zz_itemStateChanged(ItemEvent e) {
        this.setEqnText();
    }

    void checkbox_zk_itemStateChanged(ItemEvent e) {
        this.setPowerIF();
        this.setEqnText();
    }

    void checkbox_ez_itemStateChanged(ItemEvent e) {
        this.setEqnText();
    }

    private void setPowerIF() {
        if (this.checkbox_zk.getState()) {
            this.label_k.setForeground(Color.black);
            this.textField_k.setEditable(true);
        } else {
            this.label_k.setForeground(Color.gray);
            this.textField_k.setEditable(false);
        }
    }

    private void setCIF() {
        if (this.checkbox_julia.getState()) {
            this.label_rec.setForeground(Color.black);
            this.textField_rec.setEditable(true);
            this.label_imc.setForeground(Color.black);
            this.textField_imc.setEditable(true);
        } else {
            this.label_rec.setForeground(Color.gray);
            this.textField_rec.setEditable(false);
            this.label_imc.setForeground(Color.gray);
            this.textField_imc.setEditable(false);
        }
    }

    private void setEqnText() {
        String str = new String("");
        if (this.checkbox_sinz.getState()) {
            str = str.concat("sin(z) + ");
        }
        if (this.checkbox_ez.getState()) {
            str = str.concat("e^z + ");
        }
        if (this.checkbox_zz.getState()) {
            str = str.concat("z^z + ");
        }
        if (this.checkbox_zk.getState()) {
            str = str.concat("z^k + ");
        }
        str = str.concat("c");
        this.label_eqn.setText(str);
    }

    private boolean noCheckBoxSet() {
        return !(this.checkbox_sinz.getState() | this.checkbox_ez.getState() | this.checkbox_zz.getState() | this.checkbox_zk.getState());
    }

    private void set_k(double pow) {
        this.textField_k.setText(String.valueOf(pow));
    }

    private void set_k() {
        this.set_k(SpecialPlace.rec[0].pow);
    }

    private void set_n_iter(int n) {
        this.textField_n.setText(String.valueOf(n));
    }

    private void set_n_iter() {
        this.set_n_iter(SpecialPlace.rec[0].n_iter);
    }

    private void setZ() {
        this.textField_zoom.setText("2");
    }

    private void set_c(Complex p) {
        this.textField_rec.setText(String.valueOf(p.real()));
        this.textField_imc.setText(String.valueOf(p.imag()));
    }

    private void set_c() {
        this.set_c(SpecialPlace.rec[0].c);
    }

    private void set_rect() {
        this.set_rect(SpecialPlace.rec[0].zmin, SpecialPlace.rec[0].zsize);
    }

    private void set_rect(Complex zmin, double zsize) {
        this.textField_w.setText(String.valueOf(zsize));
        TextUtils.setTextFieldWithComplex(this.textField_re_z, this.textField_im_z, ComplexUtils.Offset(zmin, 0.5 * zsize));
    }

    void checkbox_mand_itemStateChanged(ItemEvent e) {
        this.setCIF();
    }

    void checkbox_julia_itemStateChanged(ItemEvent e) {
        this.setCIF();
    }

    void button_reset_actionPerformed(ActionEvent e) {
        this.set_special(this.choice_special.getSelectedIndex());
        this.setZ();
        this.redraw_canvas();
    }

    void canvas1_mouseReleased(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            this.zoom_in(e);
        }
        if ((e.getModifiers() & 4) != 0) {
            this.zoom_out(e);
        }
    }

    void zoom_in(MouseEvent e) {
        this.zoom(e, 1.0 / (double)TextUtils.getTextFieldAsInt(this.textField_zoom, 1, 2));
    }

    void zoom_out(MouseEvent e) {
        this.zoom(e, TextUtils.getTextFieldAsInt(this.textField_zoom, 1, 2));
    }

    void zoom(MouseEvent e, double zoom) {
        Complex zmin = this.get_zmin();
        double zsize = this.get_zsize();
        double scale = zsize / (double)QuarterCanvas.canvasSize;
        double zoom_size = zsize * zoom;
        Complex zoom_min = new Complex(e.getX(), QuarterCanvas.canvasSize - e.getY());
        zoom_min = zoom_min.times(scale).plus(zmin);
        zoom_min = ComplexUtils.Offset(zoom_min, -0.5 * zoom_size);
        this.set_rect(zoom_min, zoom_size);
        this.redraw_canvas();
    }

    void set_special(int index) {
        this.checkbox_sinz.setState(SpecialPlace.rec[index].is_sinz);
        this.checkbox_ez.setState(SpecialPlace.rec[index].is_ez);
        this.checkbox_zz.setState(SpecialPlace.rec[index].is_zz);
        this.checkbox_zk.setState(SpecialPlace.rec[index].is_zk);
        if (SpecialPlace.rec[index].mand) {
            this.checkbox_mand.setState(true);
        } else {
            this.checkbox_julia.setState(true);
        }
        this.set_rect(SpecialPlace.rec[index].zmin, SpecialPlace.rec[index].zsize);
        this.set_k(SpecialPlace.rec[index].pow);
        this.set_c(SpecialPlace.rec[index].c);
        this.set_n_iter(SpecialPlace.rec[index].n_iter);
        this.setPowerIF();
        this.setCIF();
        this.setEqnText();
    }

    void choice_special_itemStateChanged(ItemEvent e) {
        this.set_special(this.choice_special.getSelectedIndex());
        this.redraw_canvas();
    }
}

